package jp.nekoteki.android.demowatcher;

import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.Menu;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;

public class MainActivity extends Activity {
	private SharedPreferences prefs;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		this.prefs = PreferenceManager.getDefaultSharedPreferences(this);

		RadioGroup enable_raidos = (RadioGroup) findViewById(R.id.radioGroupEnabled);
		enable_raidos.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				// TODO Auto-generated method stub
				if (checkedId == R.id.radio_disabled) {
					MainActivity.this.cancelSchedule();
				} else {
					MainActivity.this.schedule();
				}
				
			}
		});
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		
		RadioButton radio_enabled  = (RadioButton) findViewById(R.id.radio_enabled);
		RadioButton radio_disabled = (RadioButton) findViewById(R.id.radio_disabled);
		if (this.getPendingIntent() == null) {
			radio_disabled.setChecked(true);
		} else {
			radio_enabled.setChecked(true);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public PendingIntent getPendingIntent() {
		return this.getPendingIntent(false);
	}
	
	public PendingIntent getPendingIntent(boolean create) {
		int flag;
		if (create) {
			flag = PendingIntent.FLAG_UPDATE_CURRENT;
		} else {
			flag = PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_NO_CREATE;
		}
		Context context = getBaseContext();
		Intent intent = new Intent(context, WatchService.class);
		intent.putExtra("open", this.getOpenTarget());
		intent.putExtra("watch", this.getWatchTarget());
		return PendingIntent.getService(context, 0, intent, flag);
	}
	
	public void cancelSchedule() {
		PendingIntent intent = this.getPendingIntent();
		if (intent == null) return;
		Log.d(this.getClass().getSimpleName(), "Disable watch schedule");
		AlarmManager manager = (AlarmManager) getBaseContext().getSystemService(ALARM_SERVICE);
		manager.cancel(intent);
		intent.cancel();
	}
	
	public void schedule() {
		Log.d(this.getClass().getSimpleName(), "Enable watch schedule");
		AlarmManager manager = (AlarmManager) getBaseContext().getSystemService(ALARM_SERVICE);
		manager.setInexactRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(), this.getInterval(), this.getPendingIntent(true));
	}
	
	public int getInterval() {
		int sec;
		try {
			sec = Integer.valueOf(((EditText) findViewById(R.id.text_interval)).getText().toString());
		} catch (Exception e) {
			sec = 0;
		}
		if (sec < 1)
			sec = 30;
		Log.d(this.getClass().getSimpleName(), "getInterval: "+String.valueOf(sec));
		return sec * 1000;
	}
	
	public String getWatchTarget() {
		return this.prefs.getString("watch", "com.mxtech.videoplayer.pro");
	}
	
	public String getOpenTarget() {
		return this.prefs.getString("open", "file:///sdcard/test/test.mp4");
	}
}
