package jp.nekoteki.android.demowatcher;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.app.IntentService;
import android.app.KeyguardManager;
import android.app.KeyguardManager.KeyguardLock;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.PowerManager;
import android.provider.BaseColumns;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;

public class WatchService extends IntentService {
	final static String NAME = "DemoWatchService";
	
	public WatchService() {
		super(NAME);
	}

	public WatchService(String name) {
		super(name);
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		Log.d(NAME, "Run watch handle!");

		this.forceWake();
		
		if (this.checkTopActivity(intent.getStringExtra("watch")))
			return;
 
	    String url = intent.getStringExtra("open");
	    Intent openintent = new Intent(Intent.ACTION_VIEW);
//	    String extention  = MimeTypeMap.getFileExtensionFromUrl(url);
//	    String mimetype   = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extention);
	    openintent.setData(Uri.parse(url));
//	    openintent.setType(mimetype);
	    openintent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
	    
	    Log.d(NAME, "Sending view intent with "+url);
	    startActivity(openintent);

	    // TODO: unlock support.
	}
	
	public boolean checkTopActivity(String watch) {

		ActivityManager am = (ActivityManager)this.getSystemService(ACTIVITY_SERVICE);
		String front = am.getRunningTasks(1).get(0).topActivity.getPackageName();
		Log.d(NAME, "Current top task: "+front);
		if (front.equals(watch)) {
			Log.d(NAME, watch+" is running on top.");
			return true;
		}
		/*
	    for (RunningAppProcessInfo pi : am.getRunningAppProcesses()) {
	    	Log.d(NAME, "Proc: "+pi.processName);
	    	if (watch.equals(pi.processName))
	    		return;
	    }
	    */

		Log.i(NAME, "Watch target '"+watch+"' is not top activitiy.");
	    return false;
	}
	
	public void forceWake() {
	    // force wake
	    PowerManager pm = (PowerManager) getSystemService(POWER_SERVICE);
	    if (!pm.isScreenOn()) {
	    	Log.i(NAME, "Screen is off, forcing awake.");
	    	PowerManager.WakeLock wakelock = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK
	    			| PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, NAME);
	    	wakelock.acquire();
	    	wakelock.release();
	    }
	}
}
