/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringSerializableConverter
implements Converter {
    public static final StringSerializableConverter INSTANCE = new StringSerializableConverter();

    StringSerializableConverter() {
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof String) {
            try {
                Constructor<?> con = c.getConstructor(String.class);
                con.setAccessible(true);
                return con.newInstance(value.toString());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        if (value != null) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        return null;
    }
}

