/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import net.arnx.jsonic.io.InputSource;

public class CharSequenceInputSource
implements InputSource {
    private int lines = 1;
    private int columns = 0;
    private int offset = 0;
    private int start = 0;
    int mark = -1;
    private final CharSequence cs;

    public CharSequenceInputSource(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        this.cs = cs;
    }

    public int next() {
        int n = -1;
        if (this.start < this.cs.length()) {
            n = this.cs.charAt(this.start++);
            ++this.offset;
            if (n == 13) {
                ++this.lines;
                this.columns = 0;
            } else if (n == 10) {
                if (this.offset < 2 || this.cs.charAt(this.offset - 2) != '\r') {
                    ++this.lines;
                    this.columns = 0;
                }
            } else {
                ++this.columns;
            }
        } else {
            ++this.start;
            return -1;
        }
        return n;
    }

    public void back() {
        if (this.start == 0) {
            throw new IllegalStateException("no backup charcter");
        }
        --this.start;
        if (this.start < this.cs.length()) {
            --this.offset;
            --this.columns;
        }
    }

    public int mark() {
        this.mark = this.start;
        return this.cs.length() - this.mark;
    }

    public void copy(StringBuilder sb, int len) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + len > this.cs.length()) {
            throw new IndexOutOfBoundsException();
        }
        sb.append(this.cs, this.mark, this.mark + len);
    }

    public String copy(int len) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + len > this.cs.length()) {
            throw new IndexOutOfBoundsException();
        }
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.cs.charAt(this.mark + i);
        }
        return String.valueOf(array);
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        int spos = 0;
        int max = Math.min(this.start - 1, this.cs.length() - 1);
        int charCount = 0;
        for (int i = 0; i < max + 1 && i < 20; ++i) {
            char c = this.cs.charAt(max - i);
            if (c == '\r' || c == '\n' && (max - i - 1 < 0 || this.cs.charAt(max - i - 1) != '\r')) {
                if (charCount <= 0) continue;
                break;
            }
            if (c == '\n') continue;
            spos = max - i;
            ++charCount;
        }
        return spos <= max ? ((Object)this.cs.subSequence(spos, max + 1)).toString() : "";
    }
}

