﻿using System.Drawing;
using MikuMikuPlugin;
using System;

namespace MMM_GraphEditor
{
    partial class FrameRuler
    {
        /// <summary> 
        /// 必要なデザイナー変数です。
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        public float offset = 0;

        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
        {
            base.OnPaint(e);
            renderTimeLine(e.Graphics);
        }

        private void renderTimeLine(Graphics g)
        {
            g.FillRectangle(Brushes.DarkGray, 0, 0, Width, Height);

            StringFormat ticlabel_fmt = new StringFormat(StringFormatFlags.NoClip);
            ticlabel_fmt.Alignment = StringAlignment.Center;

            int frame_width = 12;
            try
            {
                frame_width = ((GraphEditorControl) this.Parent.Parent).graphPort1.frame_width;
            }
            catch (System.Exception)
            {
                // ignore
            }

            bool has_label = false;
            bool is_em_tic = false;
            float x_pos = 0;
            for (int i = 0; (x_pos = (offset % frame_width) + i * frame_width) < Width; i++)
            {
                int cur = (int) Math.Floor(offset / frame_width) + i;
                has_label = (cur > 0 && cur % 10 == 0);
                is_em_tic = (cur % 5 == 0);
                g.DrawLine(has_label ? Pens.White : is_em_tic ? Pens.WhiteSmoke : Pens.Gainsboro,
                    x_pos,
                    Height - (is_em_tic ? 10 : 5),
                    x_pos,
                    Height);
                if (!has_label) continue;
                g.DrawString(cur.ToString(),
                    this.Font,
                    Brushes.White,
                    new Rectangle((int) x_pos - 2 * frame_width, 2, frame_width * 4, Height),
                    ticlabel_fmt);
            }

            try
            {
                Scene s = ((GraphEditorControl)this.Parent.Parent).Scene;
                if (s == null) return;
                long cur_mark = s.MarkerPosition;
                Rectangle marker_rect = new Rectangle((int) ((offset % frame_width) + (cur_mark-1.5) * frame_width), 14, frame_width * 3, 14);
                g.FillRectangle(Brushes.YellowGreen, marker_rect);
                g.DrawString(cur_mark.ToString(), this.Font, Brushes.Black, marker_rect, ticlabel_fmt);
            }
            catch (System.Exception)
            {
                // ignore
            }
        }


        #region コンポーネント デザイナーで生成されたコード

        /// <summary> 
        /// デザイナー サポートに必要なメソッドです。このメソッドの内容を 
        /// コード エディターで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // FrameRuler
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.DoubleBuffered = true;
            this.Margin = new System.Windows.Forms.Padding(0);
            this.Name = "FrameRuler";
            this.Size = new System.Drawing.Size(300, 30);
            this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.mouse_down);
            this.PreviewKeyDown += new System.Windows.Forms.PreviewKeyDownEventHandler(this.key_down);
            this.ResumeLayout(false);

        }

        #endregion
    }
}
