/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.PropertyInfo;
import net.arnx.jsonic.web.ExternalContext;
import net.arnx.jsonic.web.GatewayFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    public Boolean debug;
    public String init = "init";
    public String destroy = "destroy";
    public String encoding;
    public Boolean expire;
    public boolean namingConversion = true;
    @JSONHint(anonym="class")
    public ProcessorConfig processor;
    protected ServletConfig config;
    protected ServletContext context;
    protected HttpServlet servlet;

    public void init(HttpServlet servlet) throws ServletException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = servlet.getServletContext();
    }

    public void start(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = this.encoding;
        Boolean expire = this.expire;
        GatewayFilter.Config gconfig = (GatewayFilter.Config)request.getAttribute(GatewayFilter.GATEWAY_KEY);
        if (gconfig != null) {
            if (encoding == null) {
                encoding = gconfig.encoding;
            }
            if (expire == null) {
                expire = gconfig.expire;
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (expire == null) {
            expire = true;
        }
        if (encoding != null) {
            request.setCharacterEncoding(encoding);
            response.setCharacterEncoding(encoding);
        }
        if (expire != null && expire.booleanValue()) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
    }

    public Object getComponent(String className) throws Exception {
        Object o = this.findClass(className).newInstance();
        for (Field field : o.getClass().getFields()) {
            Class<?> cls = field.getType();
            if ("config".equals(field.getName()) && ServletConfig.class.equals(cls)) {
                field.set(o, ExternalContext.getConfig());
                continue;
            }
            if ("application".equals(field.getName()) && ServletContext.class.equals(cls)) {
                field.set(o, ExternalContext.getApplication());
                continue;
            }
            if ("request".equals(field.getName()) && HttpServletRequest.class.equals(cls)) {
                field.set(o, ExternalContext.getRequest());
                continue;
            }
            if ("response".equals(field.getName()) && HttpServletResponse.class.equals(cls)) {
                field.set(o, ExternalContext.getResponse());
                continue;
            }
            if (!"session".equals(field.getName()) || !HttpSession.class.equals(cls)) continue;
            field.set(o, ExternalContext.getSession());
        }
        return o;
    }

    public Method getMethod(Object component, String methodName, List<?> params) throws NoSuchMethodException {
        if (params == null) {
            params = Collections.emptyList();
        }
        if (this.namingConversion) {
            methodName = ClassUtil.toLowerCamel(methodName);
        }
        if (methodName.equals(this.init) || methodName.equals(this.destroy)) {
            this.debug("Method name is same init or destroy method name.");
            return null;
        }
        Class<?> c = component.getClass();
        Method method = null;
        Class<?>[] types = null;
        Method vmethod = null;
        Class<?>[] vtypes = null;
        for (Method cmethod : c.getMethods()) {
            if (Modifier.isStatic(cmethod.getModifiers()) || cmethod.isSynthetic() || cmethod.isBridge() || !cmethod.getName().equals(methodName)) continue;
            Class<?>[] ctypes = cmethod.getParameterTypes();
            if (cmethod.isVarArgs()) {
                if (ctypes.length - 1 > params.size()) continue;
                Class<?> vtype = ctypes[ctypes.length - 1].getComponentType();
                Class[] tmp = new Class[params.size()];
                System.arraycopy(tmp, 0, ctypes, 0, ctypes.length - 1);
                for (int i = ctypes.length - 1; i < tmp.length; ++i) {
                    tmp[i] = vtype;
                }
                ctypes = tmp;
                if (vmethod == null || ctypes.length > vtypes.length) {
                    vmethod = cmethod;
                    vtypes = ctypes;
                    continue;
                }
                int vpoint = Container.calcurateDistance(vtypes, params);
                int cpoint = Container.calcurateDistance(ctypes, params);
                if (cpoint > vpoint) {
                    vmethod = cmethod;
                    vtypes = ctypes;
                    continue;
                }
                if (cpoint != vpoint) continue;
                vmethod = null;
                continue;
            }
            if (ctypes.length > params.size() || types != null && ctypes.length < types.length) continue;
            if (method == null || ctypes.length > types.length) {
                method = cmethod;
                types = ctypes;
                continue;
            }
            int point = Container.calcurateDistance(types, params);
            int cpoint = Container.calcurateDistance(ctypes, params);
            if (cpoint > point) {
                method = cmethod;
                types = ctypes;
                continue;
            }
            if (cpoint != point) continue;
            method = null;
        }
        if (vmethod != null) {
            if (method == null) {
                method = vmethod;
            } else {
                int point = Container.calcurateDistance(types, params);
                int vpoint = Container.calcurateDistance(vtypes, params);
                if (vpoint > point) {
                    method = vmethod;
                }
            }
        }
        if (method == null || this.limit(c, method)) {
            this.debug("method missing: " + Container.toPrintString(c, methodName, params));
            return null;
        }
        return method;
    }

    public Object[] preinvoke(Object component, Method method, Object ... params) throws Exception {
        return params;
    }

    public Object execute(JSON json, Object component, Method method, List<?> params) throws Exception {
        Object result = null;
        AccessibleObject init = null;
        AccessibleObject destroy = null;
        if (this.init != null || this.destroy != null) {
            boolean illegalInit = false;
            boolean illegalDestroy = false;
            for (Method m : component.getClass().getMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || m.isSynthetic() || m.isBridge()) continue;
                if (m.getName().equals(this.init)) {
                    if (m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 0) {
                        init = m;
                        continue;
                    }
                    illegalInit = true;
                    continue;
                }
                if (!m.getName().equals(this.destroy)) continue;
                if (m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 0) {
                    destroy = m;
                    continue;
                }
                illegalDestroy = true;
            }
            if (illegalInit) {
                this.debug("Notice: init method must have no arguments.");
            }
            if (illegalDestroy) {
                this.debug("Notice: destroy method must have no arguments.");
            }
        }
        Type[] argTypes = method.getGenericParameterTypes();
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = i == args.length - 1 && method.isVarArgs() ? json.convert(params.subList(i < params.size() ? i : params.size(), params.size()), argTypes[i]) : json.convert(i < params.size() ? params.get(i) : null, argTypes[i]);
        }
        if (this.isDebugMode()) {
            this.debug("Execute: " + Container.toPrintString(component.getClass(), method.getName(), Arrays.asList(args)));
        }
        if (init != null) {
            if (this.isDebugMode()) {
                this.debug("Execute: " + Container.toPrintString(component.getClass(), ((Method)init).getName(), null));
            }
            if (!init.isAccessible()) {
                ((Method)init).setAccessible(true);
            }
            ((Method)init).invoke(component, new Object[0]);
        }
        args = this.preinvoke(component, method, args);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        result = method.invoke(component, args);
        result = this.postinvoke(component, method, result);
        if (destroy != null) {
            if (this.isDebugMode()) {
                this.debug("Execute: " + Container.toPrintString(component.getClass(), ((Method)destroy).getName(), null));
            }
            if (!destroy.isAccessible()) {
                ((Method)destroy).setAccessible(true);
            }
            ((Method)destroy).invoke(component, new Object[0]);
        }
        return result;
    }

    public Object postinvoke(Object component, Method method, Object result) throws Exception {
        return result;
    }

    public void exception(Exception e, HttpServletRequest request, HttpServletResponse response) throws ServletException {
    }

    public void end(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destory() {
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                c = Class.forName(name, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                c = Class.forName(name);
            }
        }
        return c;
    }

    protected boolean limit(Class<?> c, Method method) {
        return method.getDeclaringClass().equals(Object.class);
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug : false;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable e) {
        if (!this.isDebugMode()) {
            return;
        }
        if (e != null) {
            this.context.log("[DEBUG] " + message, e);
        } else {
            this.context.log("[DEBUG] " + message);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable e) {
        if (!this.isDebugMode()) {
            return;
        }
        if (e != null) {
            this.context.log("[WARNING] " + message, e);
        } else {
            this.context.log("[WARNING] " + message);
        }
    }

    public void error(String message, Throwable e) {
        if (e != null) {
            this.context.log("[ERROR] " + message, e);
        } else {
            this.context.log("[ERROR] " + message);
        }
    }

    public Object getErrorData(Throwable cause) {
        Map<String, Object> data = null;
        for (PropertyInfo pi : BeanInfo.get(cause.getClass()).getProperties()) {
            Object value;
            if (pi.getReadMember().getDeclaringClass().equals(Throwable.class) || pi.getReadMember().getDeclaringClass().equals(Object.class) || (value = pi.get(cause)) == cause) continue;
            if (data == null) {
                data = new LinkedHashMap();
            }
            data.put(pi.getName(), value);
        }
        return data != null ? data : Collections.emptyMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JSON createJSON(Locale locale) throws ServletException {
        JSON json;
        if (this.processor != null) {
            try {
                json = this.processor.type.newInstance();
                if (this.processor.locale != null) {
                    json.setLocale(this.processor.locale);
                } else {
                    json.setLocale(locale);
                }
                if (this.processor.mode != null) {
                    json.setMode(this.processor.mode);
                }
                if (this.processor.timeZone != null) {
                    json.setTimeZone(this.processor.timeZone);
                }
                if (this.processor.maxDepth != null) {
                    json.setMaxDepth(this.processor.maxDepth);
                }
                if (this.processor.prettyPrint != null) {
                    json.setPrettyPrint(this.processor.prettyPrint);
                }
                if (this.processor.initialIndent != null) {
                    json.setInitialIndent(this.processor.initialIndent);
                }
                if (this.processor.indentText != null) {
                    json.setIndentText(this.processor.indentText);
                }
                if (this.processor.suppressNull != null) {
                    json.setSuppressNull(this.processor.suppressNull);
                }
                if (this.processor.dateFormat != null) {
                    json.setDateFormat(this.processor.dateFormat);
                }
                if (this.processor.numberFormat != null) {
                    json.setNumberFormat(this.processor.numberFormat);
                }
                if (this.processor.propertyStyle != null) {
                    json.setPropertyStyle(this.processor.propertyStyle);
                }
                if (this.processor.enumStyle == null) return json;
                json.setEnumStyle(this.processor.enumStyle);
                return json;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            json = new JSON();
            json.setLocale(locale);
        }
        return json;
    }

    static boolean isJSONType(String contentType) {
        if (contentType != null) {
            return (contentType = contentType.toLowerCase()).equals("application/json") || contentType.startsWith("application/json;");
        }
        return false;
    }

    static int calcurateDistance(Class<?>[] types, List<?> params) {
        int point = 0;
        for (int i = 0; i < types.length; ++i) {
            Object param = params.get(i);
            if (param == null) continue;
            if (param instanceof String) {
                if (String.class.equals(types[i])) {
                    point += 10;
                    continue;
                }
                if (types[i].isAssignableFrom(String.class)) {
                    point += 9;
                    continue;
                }
                if (types[i].isPrimitive() || Boolean.class.equals(types[i]) || CharSequence.class.isAssignableFrom(types[i]) || Character.class.isAssignableFrom(types[i]) || Number.class.isAssignableFrom(types[i]) || Date.class.isAssignableFrom(types[i]) || Calendar.class.isAssignableFrom(types[i]) || Locale.class.equals(types[i]) || TimeZone.class.equals(types[i]) || Pattern.class.equals(types[i]) || Charset.class.equals(types[i]) || URI.class.equals(types[i]) || URL.class.equals(types[i]) || UUID.class.equals(types[i])) {
                    point += 8;
                    continue;
                }
                if (!Object.class.equals(types[i])) continue;
                ++point;
                continue;
            }
            if (param instanceof Number) {
                if (Byte.TYPE.equals(types[i]) || Short.TYPE.equals(types[i]) || Integer.TYPE.equals(types[i]) || Long.TYPE.equals(types[i]) || Double.TYPE.equals(types[i]) || Number.class.isAssignableFrom(types[i])) {
                    point += 10;
                    continue;
                }
                if (types[i].isAssignableFrom(BigDecimal.class)) {
                    point += 9;
                    continue;
                }
                if (types[i].isPrimitive() || CharSequence.class.isAssignableFrom(types[i]) || Character.class.equals(types[i]) || Boolean.class.equals(types[i]) || Date.class.isAssignableFrom(types[i]) || Calendar.class.isAssignableFrom(types[i])) {
                    point += 8;
                    continue;
                }
                if (!Object.class.equals(types[i])) continue;
                ++point;
                continue;
            }
            if (param instanceof Boolean) {
                if (Boolean.TYPE.equals(types[i]) || Boolean.class.equals(types[i])) {
                    point += 10;
                    continue;
                }
                if (types[i].isAssignableFrom(Boolean.class)) {
                    point += 9;
                    continue;
                }
                if (types[i].isPrimitive() || Number.class.isAssignableFrom(types[i]) || CharSequence.class.isAssignableFrom(types[i]) || Character.class.equals(types[i])) {
                    point += 8;
                    continue;
                }
                if (!Object.class.equals(types[i])) continue;
                ++point;
                continue;
            }
            if (param instanceof List) {
                if (Collection.class.isAssignableFrom(types[i]) || types[i].isArray()) {
                    point += 10;
                    continue;
                }
                if (types[i].isAssignableFrom(ArrayList.class)) {
                    point += 9;
                    continue;
                }
                if (Map.class.isAssignableFrom(types[i])) {
                    point += 8;
                    continue;
                }
                if (!Object.class.equals(types[i])) continue;
                ++point;
                continue;
            }
            if (!(param instanceof Map)) continue;
            if (Map.class.isAssignableFrom(types[i])) {
                point += 10;
                continue;
            }
            if (types[i].isAssignableFrom(LinkedHashMap.class)) {
                point += 9;
                continue;
            }
            if (List.class.isAssignableFrom(types[i]) || types[i].isArray()) {
                point += 8;
                continue;
            }
            if (!(types[i].isPrimitive() || Boolean.class.equals(types[i]) || CharSequence.class.isAssignableFrom(types[i]) || Character.class.isAssignableFrom(types[i]) || Number.class.isAssignableFrom(types[i]) || Date.class.isAssignableFrom(types[i]) || Calendar.class.isAssignableFrom(types[i]) || Locale.class.equals(types[i]) || TimeZone.class.equals(types[i]) || Pattern.class.equals(types[i]) || Charset.class.equals(types[i]) || URI.class.equals(types[i]) || URL.class.equals(types[i]) || UUID.class.equals(types[i]))) {
                point += 8;
                continue;
            }
            if (!Object.class.equals(types[i])) continue;
            ++point;
        }
        return point;
    }

    static String toPrintString(Class<?> c, String methodName, List<?> args) {
        StringBuilder sb = new StringBuilder(c.getName());
        sb.append('#').append(methodName).append('(');
        if (args != null) {
            String str = JSON.encode(args);
            sb.append(str, 1, str.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    static <T> T cast(Object o) {
        return (T)o;
    }

    static class ProcessorConfig {
        @JSONHint(name="class")
        public Class<? extends JSON> type = JSON.class;
        public JSON.Mode mode;
        public Locale locale;
        public TimeZone timeZone;
        public Integer maxDepth;
        public Boolean prettyPrint;
        public Integer initialIndent;
        public String indentText;
        public Boolean suppressNull;
        public String dateFormat;
        public String numberFormat;
        public NamingStyle propertyStyle;
        public NamingStyle enumStyle;

        ProcessorConfig() {
        }
    }
}

