package cloud.hmml.mmw;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.RemoteViews;

/**
 * Implementation of App Widget functionality.
 * App Widget Configuration implemented in {@link WeatherDispWidgetConfigureActivity WeatherDispWidgetConfigureActivity}
 */
public class WeatherDispWidget extends AppWidgetProvider {

    static void updateAppWidget(Context context, AppWidgetManager appWidgetManager,
                                int appWidgetId) {

        ConfigManager conf = new ConfigManager(context, appWidgetId);
        conf.saveCreatedAt();

        // Construct the RemoteViews object
        RemoteViews views = new RemoteViews(context.getPackageName(), R.layout.weather_disp_widget);

        // Set intent to open setting activity
        Intent intent = new Intent(context, WeatherDispWidgetConfigureActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(AppWidgetManager.EXTRA_APPWIDGET_ID, appWidgetId);
        PendingIntent pendingIntent = PendingIntent.getActivity(context, appWidgetId, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        views.setOnClickPendingIntent(R.id.widget_base, pendingIntent);

        // set image
        Theme theme = conf.getTheme();
        String temp_unit = "℃";
        boolean is_unit_f = conf.isTempUnitF();
        if (is_unit_f)
            temp_unit = "℉";

        if (theme.day_frame != null && theme.day_frame.equals("builtin/white")) {
            views.setImageViewResource(R.id.weather_background_today, R.drawable.day_frame_white);
            views.setImageViewResource(R.id.weather_background_tomorrow, R.drawable.day_frame_white);
        } else {
            views.setImageViewResource(R.id.weather_background_today, R.drawable.day_frame_black);
            views.setImageViewResource(R.id.weather_background_tomorrow, R.drawable.day_frame_black);
        }

        for (int tid : new int[] {R.id.txt_temp_unit1, R.id.txt_temp_unit2, R.id.txt_temp_unit3, R.id.txt_temp_unit4})
            views.setTextViewText(tid, temp_unit);

        if (conf.loadWeatherIdent(1) != null) {
            views.setImageViewBitmap(R.id.weather_image_today, theme.getIconBitmap(conf.loadWeatherIdent(1)));
            views.setTextViewText(R.id.weather_name_today, conf.loadWeatherLabel(1));
            views.setTextViewText(R.id.txt_temp_min_today, toTempString(conf.loadTempMin(1), is_unit_f));
            views.setTextViewText(R.id.txt_temp_max_today, toTempString(conf.loadTempMax(1), is_unit_f));
            Integer pop = conf.loadPoP(1);
            if (pop == null) {
                views.setViewVisibility(R.id.txt_pop_today, View.GONE);
                views.setViewVisibility(R.id.txt_pop_unit1, View.GONE);
            } else {
                views.setTextViewText(R.id.txt_pop_today, pop.toString());
                views.setViewVisibility(R.id.txt_pop_today, View.VISIBLE);
                views.setViewVisibility(R.id.txt_pop_unit1, View.VISIBLE);
            }
        }

        if (conf.loadWeatherIdent(2) != null) {
            views.setImageViewBitmap(R.id.weather_image_tomorrow, theme.getIconBitmap(conf.loadWeatherIdent(2)));
            views.setTextViewText(R.id.weather_name_tomorrow, conf.loadWeatherLabel(2));
            views.setTextViewText(R.id.txt_temp_min_tomorrow, toTempString(conf.loadTempMin(2), is_unit_f));
            views.setTextViewText(R.id.txt_temp_max_tomorrow, toTempString(conf.loadTempMax(2), is_unit_f));
            Integer pop = conf.loadPoP(2);
            if (pop == null) {
                views.setViewVisibility(R.id.txt_pop_tomorrow, View.GONE);
                views.setViewVisibility(R.id.txt_pop_unit2, View.GONE);
            } else {
                views.setTextViewText(R.id.txt_pop_tomorrow, pop.toString());
                views.setViewVisibility(R.id.txt_pop_tomorrow, View.VISIBLE);
                views.setViewVisibility(R.id.txt_pop_unit2, View.VISIBLE);
            }
        }

        Log.d("widget", "static update " + appWidgetId);
        // Instruct the widget manager to update the widget
        appWidgetManager.updateAppWidget(appWidgetId, views);

        // TODO: move to service!
        conf.updateWeather();
    }

    public static String toTempString(Integer c_temp, boolean is_f) {
        if (c_temp == null)
            return "--";
        if (!is_f)
            return c_temp.toString();

        return String.format("%.0f", (double) c_temp * 1.8 + 32.0);
    }

    @Override
    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        // There may be multiple widgets active, so update all of them
        for (int appWidgetId : appWidgetIds) {
            updateAppWidget(context, appWidgetManager, appWidgetId);
        }
    }

    @Override
    public void onDeleted(Context context, int[] appWidgetIds) {
        // When the user deletes the widget, delete the preference associated with it.
        for (int appWidgetId : appWidgetIds) {
            Log.d("widget", "Widget ID=" + appWidgetId + " has been deleted.");
            ConfigManager.purge(context, appWidgetId);
        }
    }

    @Override
    public void onEnabled(Context context) {
        // Enter relevant functionality for when the first widget is created
        Log.d("widget", "enabled");
    }

    @Override
    public void onDisabled(Context context) {
        // Enter relevant functionality for when the last widget is disabled
        Log.d("widget", "disabled");
    }

}

