class Api::V1::ForecastsController < ApplicationController
  respond_to :json
  before_action :set_target

  def show
    respond_with @area
  end

  private
  def set_target
    @area = Area.find_by!(ns: params.require(:area_ns), code: params.require(:area_code))
    @area.timezone? and
      Time.zone = @area.timezone
    start_date = Time.zone.now.to_date
    @forecasts = @area.forecasts.where('date >= ?', start_date).order(date: :asc)
  end
end
