class AreasController < ApplicationController
  load_and_authorize_resource

  def index
    respond_with(@areas)
  end

  def show
    respond_with(@area)
  end

  def new
    respond_with(@area)
  end

  def edit
  end

  def create
    @area.save
    respond_with(@area)
  end

  def update
    @area.update(area_params)
    respond_with(@area)
  end

  def destroy
    @area.destroy
    respond_with(@area)
  end

  private
  def set_area
    @area = Area.find(params[:id])
  end

  def area_params
    params.require(:area).permit(:ns, :code, :country, :pref, :name)
  end
end
