class DistSignalsController < ApplicationController
  before_action :set_dist_signal, only: [:show, :edit, :update, :destroy]

  respond_to :html

  def index
    @dist_signals = DistSignal.all.page(params[:page])
    respond_with(@dist_signals)
  end

  def show
    respond_with(@dist_signal)
  end

  def new
    @dist_signal = DistSignal.new
    respond_with(@dist_signal)
  end

  def edit
  end

  def create
    @dist_signal = DistSignal.new(dist_signal_params)
    @dist_signal.save
    respond_with(@dist_signal)
  end

  def update
    @dist_signal.update(dist_signal_params)
    respond_with(@dist_signal)
  end

  def destroy
    @dist_signal.destroy
    respond_with(@dist_signal)
  end

  private
    def set_dist_signal
      @dist_signal = DistSignal.find(params[:id])
    end

    def dist_signal_params
      params.require(:dist_signal).permit(:signature, :link, :content_type, :body)
    end
end
