class ForecastsController < ApplicationController
  before_action :set_forecast, only: [:show, :edit, :update, :destroy]

  respond_to :html

  def index
    @forecasts = Forecast.all
    respond_with(@forecasts)
  end

  def show
    respond_with(@forecast)
  end

  def new
    @forecast = Forecast.new
    respond_with(@forecast)
  end

  def edit
  end

  def create
    @forecast = Forecast.new(forecast_params)
    @forecast.save
    respond_with(@forecast)
  end

  def update
    @forecast.update(forecast_params)
    respond_with(@forecast)
  end

  def destroy
    @forecast.destroy
    respond_with(@forecast)
  end

  private
    def set_forecast
      @forecast = Forecast.find(params[:id])
    end

    def forecast_params
      params.require(:forecast).permit(:area_id, :weather_symbol, :weather_label, :date, :reported_at, :temp, :pop)
    end
end
