class WelcomeController < ApplicationController
  def index
  end

  def login
  end

  def logout
    sign_out :user
    redirect_to after_sign_out_path_for(:user)
  end

  def store_current_location
    # disable location storing on login/logout action.
    return if %w(login logout).member?(action_name)
    super
  end

  def download_theme
    id = params[:id].to_i
    target_file = Rails.root.join("data", "theme-#{id}.zip")
    target_file.exist? or raise_error_404
    DlLogEntry.create! theme_id: -id, ident: request.user_agent.to_s[0..255],
                       ip_hash: gen_ip_hash, dl_target: :orig
    send_file target_file
  end
end
