class Ability
  include CanCan::Ability

  def initialize(user)
    if user && user.is_admin?
      can :manage, :all
      return
    end

    # allows WITHOUT login
    can %i(show), User
    can %i(index new create), Theme
    can %i(show orig archive), Theme, disabled: false
    can %i(index show edit update new create), Draft

    return unless user

    # allows for logged-in users
    can %i(edit update destroy), User, id: user.id
    can %i(edit update destroy), Theme, user_id: user.id
  end
end
