require 'fileutils'
class ApplicationRecord < ActiveRecord::Base
  self.abstract_class = true

  def _zip_tmp_path(category)
    path = Rails.root.join('tmp', 'archives', category, "#{self.class.to_s.downcase}-#{id}-#{SecureRandom.hex(6)}.zip")
    FileUtils.mkdir_p path.dirname
    path
  end
end
