class ThemeDefinition
  include ActiveModel

  attr_accessor :id, :name, :url, :author, :day_frame, :license, :short_desc

  def initialize(attrs = {})
    (attrs || {}).each do |k, v|
      public_send "#{k}=", v
    end
  end

  def draft=(draft)
    draft.kind_of?(Draft) or theme = Draft.find(draft)
    %i(name author url).each do |attr|
      self.public_send "#{attr}=", draft.public_send(attr)
    end
    self.day_frame = draft.read_attribute_before_type_cast(:day_frame)
    draft
  end
  alias_method :draft_id=, :draft=

  def draft_key(key)
    self.draft = Draft.find_by!(key: key)
  end

  def theme=(theme)
    theme.kind_of?(Theme) or theme = Theme.find(theme)
    %i(id name author url short_desc).each do |attr|
      self.public_send "#{attr}=", theme.public_send(attr)
    end
    self.day_frame = theme.read_attribute_before_type_cast(:day_frame)
    theme
  end
  alias_method :theme_id=, :theme=

  def as_json(opts = {})
    ret = {
      schema_version: 1,
    }
    %i(id name author url short_desc day_frame).each do |a|
      ret[a] = public_send(a)
    end
    ret.stringify_keys
  end
end
