class User < ApplicationRecord
  # Include default devise modules. Others available are:
  # :confirmable, :lockable, :timeoutable and
  # :database_authenticatable, :registerable,
  # :recoverable, :rememberable, :validatable,
  devise :trackable, :omniauthable

  validates :name, presence: true

  has_many :themes

  def tw_url?
    !tw_url.blank?
  end

  def tw_url
    tw_nick or return nil
    "https://twitter.com/#{tw_nick}"
  end

  def icon_tag(opts = {})
    tw_img_url or return ''.html_safe
    opts = {size: '20x20', class: 'user-icon d-inline-block'}.merge(opts)
    ActionController::Base.helpers.image_tag tw_img_url, opts
  end
end
