class ApplicationController < ActionController::Base
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  protect_from_forgery with: :exception
  respond_to :html, :xml, :json
  responders :flash
  before_action :set_locale

  def set_locale
    ua_locale = request.env['HTTP_ACCEPT_LANGUAGE'].to_s.scan(/^[a-z]{2}/).first
    if Rails.application.config.supported_locales.member? ua_locale.to_sym
      I18n.locale = ua_locale.to_sym
    end
  end


end
