class CreateNaviVoices < ActiveRecord::Migration
  def change
    create_table :navi_voices do |t|
      t.string :title, null: false
      t.string :archive_md5, default: '', null: false
      t.float :rating
      t.text :description
      t.string :unit, default: 'metric', null: false
      t.string :lang, null: false, default: 'ja'
      t.string :author, null: false, default: ''
      t.string :delete_key, null: false, default: ''
      t.boolean :disabled, default: false, null: false

      t.timestamps
    end
    add_index :navi_voices, [:rating, :disabled]
    add_index :navi_voices, :author
    add_index :navi_voices, [:created_at, :disabled]
  end
end
