// Momiji.Test.MM.MidiIn.cpp : C vWFNg t@CłB

#include "stdafx.h"
#using <Momiji.Core.dll>

using namespace System;

void test5()
{
	{
		System::UInt32 nums = Momiji::Core::Midi::In::Device::GetNumDevices();
		Console::WriteLine("[{0}]", nums);

		Console::WriteLine("====================================================");
		for (System::UInt32 idx = 0; idx <= nums; idx++) {

			try
			{
				Momiji::Interop::Winmm::MidiInCapabilities^ cap = 
					Momiji::Core::Midi::In::Device::GetCapabilities(idx);

				Console::Write("[{0}]", idx);
				Console::Write("[{0}]", cap->manufacturerID);
				Console::Write("[{0}]", cap->productID);
				Console::Write("[{0}]", cap->driverVersion);
				Console::Write("[{0}]", cap->productName);
				Console::Write("[{0}]", cap->support);
				Console::WriteLine();

				Console::WriteLine("[{0}]", cap->manufacturerGuid);
				Console::WriteLine("[{0}]", cap->productGuid);
				Console::WriteLine("[{0}]", cap->nameGuid);
			}
			catch(Exception^ e)
			{
				Console::WriteLine(e->ToString());
			}
		}
	}
}

void test6()
{
	try
	{
		Momiji::Core::Midi::In::Device^ in = gcnew Momiji::Core::Midi::In::Device(0);
		try
		{
			Momiji::Interop::Winmm::MidiInCapabilities^ cap = in->GetCapabilities();

			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			delete cap;

		//	out->open();

			System::GC::Collect();

		//	out->close();
		}
		finally
		{
			delete in;
		}
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

ref class TestTuru
{
	Momiji::Core::Midi::In::Device^ in;
	Momiji::Core::Midi::Out::Device^ out;

private:
	void OnInData(System::UInt32 data, System::UInt32 time)
	{
		Console::WriteLine("[{0,4:X}][{1,4:X}]", data, time);
		out->SendShort(data);
	}

	void OnInLongData(array<System::Byte>^ data, System::UInt32 time)
	{
		Console::WriteLine("[{0,4:X}][{1,4:X}]", data, time);
		out->SendLong(data);
	}

public:
	TestTuru()
	{
		in = gcnew Momiji::Core::Midi::In::Device(0);
		in->OnData += gcnew Momiji::Core::Midi::In::Device::ShortEvent(this, &TestTuru::OnInData);
		in->OnLongData += gcnew Momiji::Core::Midi::In::Device::LongEvent(this, &TestTuru::OnInLongData);

		out = gcnew Momiji::Core::Midi::Out::Device(0);
	}
	~TestTuru()
	{
		this->!TestTuru();
	}
	!TestTuru()
	{
		delete in;
		delete out;
	}
};

void test7()
{
	try
	{
		TestTuru^ test = gcnew TestTuru();
		try
		{
			System::Console::ReadLine();
		}
		finally
		{
			delete test;
		}
		System::GC::Collect();

	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

int main(array<System::String ^> ^args)
{
	Console::WriteLine("====================================================test5");
	test5();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test6");
	test6();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test7");
	test7();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();
 
	Console::WriteLine("====================================================");
	System::Console::ReadLine();
	return 0;
}
