# Internationalization

Available locales are

| Code | Language | Translators |
| ---- | -------- | ---------- |
| `auto` | Auto-detect | |
| `en` | English  | [@Etto48][Etto48] |
| `it-IT` | Italian (Italy) | [@Etto48][Etto48] |
| `fr-FR` | French (France) | [@Pallandos][Pallandos] |
| `es-ES` | Spanish (Spain) | [@chocolatemilq][chocolatemilq] |
| `de-DE` | German (Germany) | AI |
| `ja-JP` | Japanese (Japan) | AI |
| `zh-CN` | Simplified Chinese (China) | [@Meow0x7E][Meow0x7E] |
| `zh-TW` | Traditional Chinese (Taiwan) | [@Meow0x7E][Meow0x7E] |
| `zh-HK` | Traditional Chinese (Hong Kong) | [@Meow0x7E][Meow0x7E] |
| `tr-TR` | Turkish (Turkey) | [@orhun][orhun] [@arda-guler][arda-guler] |

You can set the locale with the key `app.locale` in the settings file. See the [settings documentation](./SETTINGS.md) for more information.

[Etto48]: https://github.com/Etto48
[Meow0x7E]: https://github.com/Meow0x7E
[orhun]: https://github.com/orhun
[arda-guler]: https://github.com/arda-guler
[chocolatemilq]: https://github.com/chocolatemilq
[Pallandos]: https://github.com/Pallandos

## Auto-detect

The `auto` locale (default one) will try to detect the user's locale based on the system settings. It first tries to match exactly the locale code, then it falls back to the language code, and finally to English (`en`) if no match is found.

## Contributing

You are welcome to contribute a new locale or improve an existing one.

If you use AI to translate, please communicate clearly in the pull request that the translation was done by AI.

### Creating a New Locale

1. (mandatory) Create a new file in the `locales` directory with the name `<code>.yml`, where `<code>` is the locale code (e.g., `it-IT.yaml` for Italian). The file should contain all the keys and values needed for the locale, following the structure of `locales/en.yml` as a reference.
You can use the `locales/en.yml` file as a template and translate the values to your desired language.
2. (optional) Add the new locale to the `package.metadata.i18n.available-locales` array in Cargo.toml.
3. (optional) Add the new locale to the `Locale` enum in `src/app/settings/locale.rs`. To do so, follow the pattern of existing locales.
4. (optional) Add the new locale to this file (`docs/I18N.md`) in the table above, including the translator's GitHub username or `AI` if you used it to generate the translation.
5. (mandatory) Create a pull request with the changes.

### Improving an Existing Locale

1. (mandatory) Edit the existing locale file in the `locales` directory (e.g., `locales/it-IT.yml` for Italian).
2. (optional) Add you name to the translator column in the table above in this file (`docs/I18N.md`).
3. (mandatory) Create a pull request with the changes.
