/*@@@
File:		vlist.hxx
Version:	2.00
Description:	Class VLIST - Doubly Linked List Class
Author:		Nassib Nassar, nassar@etymon.com
                Copyright (C) 2001 Etymon Systems, Inc.
@@@*/


#ifndef VLIST_HXX
#define VLIST_HXX


#include "gdt.h"
#include "defs.hxx"


class VNODE {
	friend class VLIST;
public:
	VNODE();
	virtual ~VNODE();
private:
	VNODE* Next;
	VNODE* Prev;
};


class VLIST {
public:
	VLIST();
	virtual void Clear();
	virtual void EraseAfter(const INT Index);
	virtual void Reverse();
	virtual INT GetTotalEntries() const;
	virtual ~VLIST();
protected:
	virtual void AddNode(VNODE* Node);
	virtual VNODE* GetNodePtr(const INT Index) const;
	virtual VNODE* GetNextNodePtr(VNODE* Node) const;
private:
	VNODE* Head;
	VNODE* Tail;
};


#endif
