/* $Id: strlist.hxx,v 1.7 1999/04/17 03:23:28 cnidr Exp $ */
/************************************************************************
Copyright Notice

Copyright (c) MCNC, Clearinghouse for Networked Information Discovery and
Retrieval, 1994. 

Permission to use, copy, modify, distribute, and sell this software and
its documentation, in whole or in part, for any purpose is hereby granted
without fee, provided that

1. The above copyright notice and this permission notice appear in all
copies of the software and related documentation. Notices of copyright
and/or attribution which appear at the beginning of any file included in
this distribution must remain intact. 

2. Users of this software agree to make their best efforts (a) to return
to MCNC any improvements or extensions that they make, so that these may
be included in future releases; and (b) to inform MCNC/CNIDR of noteworthy
uses of this software. 

3. The names of MCNC and Clearinghouse for Networked Information Discovery
and Retrieval may not be used in any advertising or publicity relating to
the software without the specific, prior written permission of MCNC/CNIDR. 

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY
OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 

IN NO EVENT SHALL MCNC/CNIDR BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE
POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
************************************************************************/

/*@@@
File:		strlist.hxx
Version:	1.3
$Revision: 1.7 $
Description:	Class STRLIST - String List
Author:		Nassib Nassar, nrn@cnidr.org
@@@*/

#ifndef STRLIST_HXX
#define STRLIST_HXX

#include <stdio.h>
#include <string.h>

#include "defs.hxx"
#include "string.hxx"
#include "vlist.hxx"


class STRNODE : public VNODE {
	friend class STRLIST;
public:
	STRNODE();
private:
	STRING String;
};


class STRLIST : public VLIST {
public:
	STRLIST();
	STRLIST& operator=(const STRLIST& OtherStrlist);
	void AddEntry(const STRING& StringEntry);
	void AddEntry(const CHR* Entry);
	void SetEntry(const SIZE_T Index, const STRING& StringEntry);
	void GetEntry(const SIZE_T Index, STRING* StringEntry) const;
	void Split(const CHR* Separator, const STRING& TheString);
	void Split(const CHR Separator, const STRING& TheString);
	void Join(const CHR* Separator, STRING* StringBuffer);
	SIZE_T SearchCase(const STRING& SearchTerm);
	void GetValue(const CHR* Title, STRING* StringBuffer);
	void GetValue(const STRING& Title, STRING* StringBuffer);
	void Dump(const PFILE fp) ;
//	friend ostream & operator<<(ostream& os, const STRLIST& str);
};

typedef STRLIST* PSTRLIST;

#endif
