/*@@@
File:		vlist.cxx
Version:	2.00
Description:	Class VLIST - Doubly Linked List Class
Author:		Nassib Nassar, nassar@etymon.com
                Copyright (C) 2001 Etymon Systems, Inc.
@@@*/


#include "vlist.hxx"


// VNODE


VNODE::VNODE() {
	Next = 0;
	Prev = 0;
}


VNODE::~VNODE() {
}


// VLIST


VLIST::VLIST() {
	Head = 0;
	Tail = 0;
}


INT VLIST::GetTotalEntries() const {
	INT x = 0;
	VNODE* p = Head;
	while (p != 0) {
		x++;
		p = p->Next;
	}
	return x;
}


void VLIST::AddNode(VNODE* Node) {
	Node->Prev = Tail;
	Node->Next = 0;
	if (Head == 0) {
		Head = Node;
	} else {
		Tail->Next = Node;
	}
	Tail = Node;
}


VNODE* VLIST::GetNodePtr(const INT Index) const {
	INT x;
	VNODE* p;

	for (x = 1, p = Head;
	     (p) && (x < Index);
	     x++, p = p->Next) {
	}
	return p;
}


VNODE* VLIST::GetNextNodePtr(VNODE* Node) const {
	return Node->Next;
}


void VLIST::Clear() {
	VNODE* p = Head;
	VNODE* n;
	while (p) {
		n = p->Next;
		delete p;
		p = n;
	}
	Head = 0;
	Tail = 0;
}


void VLIST::EraseAfter(const INT Index) {
	VNODE* a;
	VNODE* p;
	VNODE* n;
	
	if (Index == 0) {
		Clear();
	}

	a = GetNodePtr(Index);
	if (a) {
		p = a->Next;
		while (p) {
			n = p->Next;
			delete p;
			p = n;
		}
		a->Next = 0;
		Tail = a;
	}
}


void VLIST::Reverse() {
	VNODE* p = Head;
	VNODE* n = 0;
	while (p) {
		p->Prev = p->Next;
		p->Next = n;
		n = p;
		p = p->Prev;
	}
	Tail = Head;
	Head = n;
}


VLIST::~VLIST() {
	Clear();
}
