<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD/DTD NetBSD XSLT 1.0 DTD//EN"
	 "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: citerefentry-docbook-html.xsl,v 1.5 2024/03/19 21:54:09 andvar Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:html="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="html"
		version="1.0">

<!-- XSL template to generate man reference link -->

  <xsl:template name="generate.citerefentry.link">
    <!--
      "os" attribute can be used on citerefentry template to set a specific
      release version for the man reference and it will override the release
      attribute above.
    -->
    <xsl:variable name="release" select="@os"/>
    <!-- arch attribute should be used to specify the architecture -->
    <xsl:variable name="arch" select="@arch"/>
    <xsl:text>//man.NetBSD.org/</xsl:text>
    <xsl:text>&os;-</xsl:text>
    <xsl:choose>
      <xsl:when test="boolean($release)">
        <xsl:value-of select="$release"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&release.latest;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>/</xsl:text>
    <xsl:choose>
      <xsl:when test="boolean($arch)">
        <xsl:value-of select="$arch"/>
        <xsl:text>/</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:value-of select="refentrytitle"/>
    <xsl:text>.</xsl:text>
    <xsl:value-of select="manvolnum"/>
  </xsl:template>

  <!--
    With mode="no.anchor.mode" the template produces plain text without any markup.
    This can be used to get nicer output than the simple text concatenation of
    "xsl:value-of".
  -->
  <xsl:template match="citerefentry" mode="no.anchor.mode">
    <xsl:value-of select="refentrytitle"/>
    <xsl:text>(</xsl:text>
    <xsl:value-of select="manvolnum"/>
    <xsl:text>)</xsl:text>
  </xsl:template>
</xsl:stylesheet>

