/*
 * nasd_cheops_cl_modinit_user.c
 *
 * Register Cheops RPC-specific modules for user library
 */
/*
 * Copyright (c) 1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Sean Levy
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon the
 * rights to redistribute these changes.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_cheops_client.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
# include <nasd/nasd_cheops_client_dce.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
# include <nasd/nasd_cheops_client_srpc.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

nasd_cheops_default_bindings_t nasd_cheops_user_bindings;
int nasd_cheops_user_bindings_handles[] = {
#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
  NASD_BIND_DCE_DIRECT_UDP
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
  NASD_BIND_SRPC
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE
# if 0 /* not yet */
  NASD_BIND_MSGQ,
  NASD_BIND_COLOCATE
# endif /* not yet */
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE */
};

void
nasd_cheops_client_mods_load(void)
{
  nasd_cheops_user_bindings.bindings = nasd_cheops_user_bindings_handles;
  nasd_cheops_user_bindings.nbindings =
    (sizeof(nasd_cheops_user_bindings_handles) /
     sizeof(nasd_cheops_user_bindings_handles[0]));
  nasd_cheops_default_bindings = &nasd_cheops_user_bindings;

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
  nasd_cheops_client_dce_register(1);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
  nasd_cheops_client_srpc_register(1);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

#if 0
  nasd_cheops_client_msgq_register(1);
#endif /* 0 */
}
