/* nasd_linux_lseek.c
 *
 * lseek() front-end for linux userland
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_general.h>
#include <unistd.h>
#include <linux/unistd.h>

_syscall5(int, _llseek,
	  uint, fd,
	  ulong, hi,
	  ulong, lo,
	  loff_t *, res,
	  uint, wh);

nasd_uint64 nasd_lseek(int fd, nasd_uint64 offset, int whence, int *err) {
  unsigned long offset_high, offset_low;
  loff_t result;

  offset_high = (offset & 0xFFFFFFFF00000000ULL) >> 32;
  offset_low  = (offset & 0x00000000FFFFFFFFULL);

  *err = _llseek(fd, offset_high, offset_low, &result, whence);

  return result;
}
