/*
 * nasd_error.c
 *
 * NASD error table
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_common.h>
#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
#include <nasd/nasd_srpc_types.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */
#include <nasd/nasd_edrfs_types.h>

#define KASE(_v_,_s_) case _v_: return(_s_);

#define PUNT_STR "Unknown NASD error and internal error reporting mechanism failure"

char *
nasd_error_string(
  nasd_status_t  err)
{
  switch(err) {
    KASE(NASD_SUCCESS,"Success")
    KASE(NASD_NO_MEM,"Out of memory (or other resource)")
    KASE(NASD_FAIL,"Internal operation failure")
    KASE(NASD_NO_MORE_OBJECTS,"No more objects may be created in partition")
    KASE(NASD_BAD_TRANSFER_STATE,"Bad state after piped transfer")
    KASE(NASD_AUTHCHECK_FAILED,"Authorization check failed")
    KASE(NASD_BAD_IDENTIFIER,"Bad NASD id")
    KASE(NASD_BAD_ATTR_SET,"Bad attribute fieldmask value")
    KASE(NASD_OP_NOT_SUPPORTED,"Operation not supported")
    KASE(NASD_BAD_TIMESPEC,"Bad timespec")
    KASE(NASD_NO_FREE_IDS,"No free NASD ids")
    KASE(NASD_GUARD_CHECK_FAILED,"Guard check failed")
    KASE(NASD_BAD_IO_LIST_LEN,"Bad I/O list length")
    KASE(NASD_BAD_IO_LIST,"Bad I/O list")
    KASE(NASD_BAD_OFFSET,"Bad offset")
    KASE(NASD_BAD_LEN,"Bad length")
    KASE(NASD_RPC_TRAP,"RPC exception")
    KASE(NASD_BAD_FIELDMASK,"Bad fieldmask")
    KASE(NASD_BAD_NONCE,"Nonce on request was bad")
    KASE(NASD_INSUFFICIENT_PERM,"Insufficient permissions for operation")
    KASE(NASD_BAD_KEYTYPE,"Key type not valid for operation")
    KASE(NASD_WEAK_COOKIE,"Cookie does not have required protection for drive minimums")
    KASE(NASD_WRONG_NI,"Cookie NI and Request NI do no match")
    KASE(NASD_WRONG_DRIVE,"Cookie drive_name does not match expected value")
    KASE(NASD_TIMEOUT,"Timed out")
    KASE(NASD_NO_SPACE,"No space left on disk or partition")
    KASE(NASD_EXPIRED_CAPABILITY,"Capability expired")
    KASE(NASD_BAD_PARTITION,"Bad or invalid partition identifier")
    KASE(NASD_RPC_FAILURE,"RPC failed")
    KASE(NASD_TRY_LOCK_BAD_IMPL,"Bad implementation of try_lock, Jim is really bitter")
    KASE(NASD_PIPE_CB_FAIL,"Pipe callback failed")
    KASE(NASD_BAD_NONCE_REPLY,"Nonce on reply was bad")
    KASE(NASD_NOT_ON_CONTROL,"Operation not allowed on control object")
    KASE(NASD_KEYINIT_FAILED,"Unable to initialize cryptographic keys")
    KASE(NASD_BAD_DIGEST_REQ,"Digest on the REQUEST did not have the expected value")
    KASE(NASD_BAD_DIGEST_REPLY,"Digest on the REPLY did not have the expected value")
    KASE(NASD_UNSUPPORTED_PROTECTION,"Request used protection that is not supported")
    KASE(NASD_DRIVE_PROTECTION,"Request used protection that did not meet drive specified minimum")
    KASE(NASD_OFFLINE,"Unit off-line")
    KASE(NASD_REMOTE_TRAP,"Remote exception trapped")
    KASE(NASD_DRIVE_INITIALIZED,"Drive was already initialized")
    KASE(NASD_DRIVE_UNINITIALIZED,"Drive has not been initialized")
    KASE(NASD_CAP_PROTECTION,"Request used protection that did not meet capability specified minimum")
    KASE(NASD_PART_PROTECTION,"Request used protection that did not meet partition specified minimum")
    KASE(NASD_SECURITY_MISMATCH,"Fields in the security_param and capability_args did not match when they were expected to.")
    KASE(NASD_IMMUTABLE_KEY,"The master key is immutable and may not be changed")
    KASE(NASD_WRONG_PARTITION,"The capability is not valid for the requested partition")
    KASE(NASD_REQUEST_OUTSIDE_RANGE,"The bytes addressed in the request are outside the range permitted by the capability");

    /*
     *  Remote execution/active disk
     */

    KASE(NASD_REMOTE_ARGS_FAIL,"Drive could not read arguments from pipe");
    KASE(NASD_REMOTE_ALREADY_ATTACHED," Cannot attach; function already attached");
    KASE(NASD_REMOTE_UNATTACHED,"Cannot invoke/detach; no function attached");
    KASE(NASD_REMOTE_BAD_FUNCTION,"No function by that name exists");
    KASE(NASD_REMOTE_BAD_MARSHALL,"Marshalling test failed");

    /*
     * API
     */
    KASE(NASD_CTRL_ID_CHECK_FAILED,"Request control id didn't match reply")
    KASE(NASD_BAD_MEM_LIST,"Bad memory list")
    KASE(NASD_MEM_LIST_ERR,"Error walking memory list")
    KASE(NASD_REMOTE_OVERRUN,"Remote agent overran local buffer")
    KASE(NASD_BAD_HANDLE,"Request issued with bad drive handle")
    KASE(NASD_BAD_HANDLE_TYPE,"Request issued with bad or incompatible handle type")
    KASE(NASD_BAD_BINDING_PARAM,"Bad binding parameter")
    KASE(NASD_BAD_BINDING_PARAM_LEN,"Bad binding parameter length")
    KASE(NASD_BINDING_OP_NOSUPP,"Operation not supported by binding type")
    KASE(NASD_RPC_LOCAL_FAIL,"Local RPC failure")
    KASE(NASD_SYS_NOT_INITIALIZED,"Subsystem not initialized")
    KASE(NASD_SYS_ALREADY_INITIALIZED,"Subsystem already initialized")
    KASE(NASD_RPCMOD_INIT_FAIL,"RPC-specific module failed initialization")
    KASE(NASD_BINDING_INVALIDATED,"Handle invalidated")
    KASE(NASD_BINDING_NOIMPL,"Binding does not implement operation")
    KASE(NASD_NO_KERNEL_SUPPORT,"NASD support not loaded in kernel")
    KASE(NASD_NO_KPDEV_SUPPORT,"kpdev support not loaded in kernel")
    KASE(NASD_NO_DEFAULT_BINDING,"no default binding registered")
    KASE(NASD_KPDEVS_BUSY,"all kpdevs are busy")
    KASE(NASD_KPDEV_ALREADY_BOUND,"kpdev already bound")
    KASE(NASD_CTRL_IO_BAD_LEN,"I/O on control object returned bad length")
    KASE(NASD_RPCMOD_NO_GETINFO,"RPC-specific module does not support getinfo")
    KASE(NASD_AGAIN,"RPC was interrupted and should be retried")

    /*
     * Drive-internal
     */
    KASE(NASD_BAD_LAYOUT_TYPE,"Bad layout type (drive-internal error)")
    KASE(NASD_BAD_BLKNO,"Bad block number (drive-internal error)")
    KASE(NASD_BAD_BLKCNT,"Bad block count (drive-internal error)")
    KASE(NASD_EJECTING,"Ejecting block (drive-internal status)")
    KASE(NASD_BLOCK_NOT_CACHED,"Block not cached (drive-internal status)")
    KASE(NASD_BLOCK_PARTIAL,"Partial block complete (drive-internal status)")
    KASE(NASD_OBJ_REMOVING,"Removing object (drive-internal status)")
    KASE(NASD_GOOD_DIGEST," XXX !!! DOCUMENT THIS ERROR CODE !!! ")
    KASE(NASD_BAD_DIGEST," XXX !!! DOCUMENT THIS ERROR CODE !!! ")
    KASE(NASD_IOSYS_FULL,"I/O subsystem is full (drive-internal error)")
    KASE(NASD_BAD_IOQUEUE_TYPE,"Bad I/O queue type (drive-internal error)")
    KASE(NASD_BAD_IOQUEUE_LEN,"Bad I/O queue length (drive-internal error)")

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
    /*
     * SRPC errors
     */
    KASE(NASD_SRPC_ALREADY_DISCONN,"already disconnecting (SRPC)")
    KASE(NASD_SRPC_BAD_ADDR,"bad IP address (SRPC)")
    KASE(NASD_SRPC_BAD_PORT,"bad IP portnumber (SRPC)")
    KASE(NASD_SRPC_CANNOT_CONNECT,"cannot connect (SRPC)")
    KASE(NASD_SRPC_SENDSTATE_BAD,"send state bad (SRPC)")
    KASE(NASD_SRPC_CANNOT_BIND,"cannot bind to port (SRPC)")
    KASE(NASD_SRPC_CALL_ABORTED,"call aborted (SRPC)")
    KASE(NASD_SRPC_CALL_ABORTED_DISC,"call aborted, handle-caller must disconnect(SRPC)")
    KASE(NASD_SRPC_PIPE_TERMINATED,"pipe terminated (SRPC)")
    KASE(NASD_SRPC_RECVSTATE_BAD,"bad receive state (SRPC)")
    KASE(NASD_SRPC_BAD_PIPEORDER,"bad pipe order (SRPC)")
    KASE(NASD_SRPC_BAD_BUFLEN,"bad buffer length (SRPC)")
    KASE(NASD_SRPC_NOT_ALL_OPTIONS_SET,"not all options set (SRPC status)")
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

    /*
     * EDRFS errors
     */
    KASE(NASD_EDRFS_BAD_MARKER_VERF,"EDRFS: in_markerv bad or stale")
    KASE(NASD_EDRFS_STALE_ID,"EDRFS: stale or bad id")
    KASE(NASD_EDRFS_BAD_NAME,"EDRFS: bad name")
    KASE(NASD_EDRFS_ALREADY_EXISTS,"EDRFS: name already exists")
    KASE(NASD_EDRFS_NOT_DIR,"EDRFS: not a directory")
    KASE(NASD_EDRFS_IS_DIR,"EDRFS: is a directory")
    KASE(NASD_EDRFS_DIR_NOT_EMPTY,"EDRFS: directory not empty")

    default:
      return("code not recognized by nasd_error_string()");
  }
}
