/*
 * mpdrspeed_common.h
 *
 * Shared info for mpdrspeed test
 *
 * Authors: David Rochberg, Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__MPDRSPEED_COMMON_H_
#define _NASD__MPDRSPEED_COMMON_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <sys/time.h>

#ifdef NSEC_PER_SEC
#undef NSEC_PER_SEC
#endif /* NSEC_PER_SEC */
#define NSEC_PER_SEC 1000000000

#ifndef USEC_PER_SEC
#define USEC_PER_SEC (1000000)
#endif /* USEC_PER_SEC */


#ifndef timespec_sub
#define timespec_sub(result, subtrahend) {          \
	if ((result).tv_nsec >= (subtrahend).tv_nsec) { \
		(result).tv_nsec -= (subtrahend).tv_nsec;   \
		(result).tv_sec -= (subtrahend).tv_sec;     \
	}                                               \
	else {                                          \
		(result).tv_nsec += NSEC_PER_SEC;           \
		(result).tv_nsec -= (subtrahend).tv_nsec;   \
		(result).tv_sec -= (subtrahend).tv_sec + 1; \
	}                                               \
}
#endif /* !timespec_sub */

#ifndef timeval_sub
#define timeval_sub(result, subtrahend) {          \
	if ((result).tv_usec >= (subtrahend).tv_usec) { \
		(result).tv_usec -= (subtrahend).tv_usec;   \
		(result).tv_sec -= (subtrahend).tv_sec;     \
	}                                               \
	else {                                          \
		(result).tv_usec += USEC_PER_SEC;           \
		(result).tv_usec -= (subtrahend).tv_usec;   \
		(result).tv_sec -= (subtrahend).tv_sec + 1; \
	}                                               \
}
#endif /* !timeval_sub */



#define MULTI_BUF_SIZE (1024)
#define MPDRSPEED_MULTI_MAGIC ("mpdrspeedobjects")
#define MPDRSPEED_MAX_OBJS (64)
typedef struct mpdrspeed_header_s {
  char			magic[16];
  nasd_uint64		nobjects;
  nasd_identifier_t	objects[MPDRSPEED_MAX_OBJS];
} mpdrspeed_header_t;
  

#endif /* !_NASD__MPDRSPEED_COMMON_H_ */
