/*
 * nasd_edrfs_mq.h
 *
 * Message-queue and shared memory interface to an EDRFS file manager.
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_EDRFS_MQ_H_
#define _NASD_EDRFS_MQ_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct NASDMQ_edrfs_null_msg_s {
  int seqnum;
  int replyq;
} NASDMQ_edrfs_null_msg_t;

typedef struct NASDMQ_edrfs_null_rep_s {
  nasd_status_t nasd_status;
  nasd_rpc_status_t op_status;
} NASDMQ_edrfs_null_rep_t;

typedef struct NASDMQ_edrfs_mount_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_mount_args_t args;
} NASDMQ_edrfs_mount_msg_t;

typedef struct NASDMQ_edrfs_mount_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_mount_res_t res;
} NASDMQ_edrfs_mount_rep_t;

typedef struct NASDMQ_edrfs_fsstat_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_fsstat_args_t args;
} NASDMQ_edrfs_fsstat_msg_t;

typedef struct NASDMQ_edrfs_fsstat_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_fsstat_res_t res;
} NASDMQ_edrfs_fsstat_rep_t;

typedef struct NASDMQ_edrfs_fsinfo_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_fsinfo_args_t args;
} NASDMQ_edrfs_fsinfo_msg_t;

typedef struct NASDMQ_edrfs_fsinfo_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_fsinfo_res_t res;
} NASDMQ_edrfs_fsinfo_rep_t;

typedef struct NASDMQ_edrfs_lookup_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_lookup_args_t args;
} NASDMQ_edrfs_lookup_msg_t;

typedef struct NASDMQ_edrfs_lookup_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_lookup_res_t res;
} NASDMQ_edrfs_lookup_rep_t;

typedef struct NASDMQ_edrfs_readdir_msg_s {
  int seqnum;
  int replyq;
  int shmid;
  nasd_edrfs_readdir_args_t args;
} NASDMQ_edrfs_readdir_msg_t;

typedef struct NASDMQ_edrfs_readdir_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_readdir_res_t res;
} NASDMQ_edrfs_readdir_rep_t;

typedef struct NASDMQ_edrfs_access_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_access_args_t args;
} NASDMQ_edrfs_access_msg_t;

typedef struct NASDMQ_edrfs_access_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_access_res_t res;
} NASDMQ_edrfs_access_rep_t;

typedef struct NASDMQ_edrfs_setattr_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_setattr_args_t args;
} NASDMQ_edrfs_setattr_msg_t;

typedef struct NASDMQ_edrfs_setattr_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_setattr_res_t res;
} NASDMQ_edrfs_setattr_rep_t;

typedef struct NASDMQ_edrfs_create_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_create_args_t args;
} NASDMQ_edrfs_create_msg_t;

typedef struct NASDMQ_edrfs_create_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_create_res_t res;
} NASDMQ_edrfs_create_rep_t;

typedef struct NASDMQ_edrfs_symlink_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_symlink_args_t args;
} NASDMQ_edrfs_symlink_msg_t;

typedef struct NASDMQ_edrfs_symlink_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_symlink_res_t res;
} NASDMQ_edrfs_symlink_rep_t;

typedef struct NASDMQ_edrfs_remove_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_remove_args_t args;
} NASDMQ_edrfs_remove_msg_t;

typedef struct NASDMQ_edrfs_remove_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_remove_res_t res;
} NASDMQ_edrfs_remove_rep_t;

typedef struct NASDMQ_edrfs_mkdir_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_mkdir_args_t args;
} NASDMQ_edrfs_mkdir_msg_t;

typedef struct NASDMQ_edrfs_mkdir_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_mkdir_res_t res;
} NASDMQ_edrfs_mkdir_rep_t;

typedef struct NASDMQ_edrfs_rmdir_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_rmdir_args_t args;
} NASDMQ_edrfs_rmdir_msg_t;

typedef struct NASDMQ_edrfs_rmdir_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_rmdir_res_t res;
} NASDMQ_edrfs_rmdir_rep_t;

typedef struct NASDMQ_edrfs_newcookie_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_newcookie_args_t args;
} NASDMQ_edrfs_newcookie_msg_t;

typedef struct NASDMQ_edrfs_newcookie_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_newcookie_res_t res;
} NASDMQ_edrfs_newcookie_rep_t;

typedef struct NASDMQ_edrfs_rename_msg_s {
  int seqnum;
  int replyq;
  nasd_edrfs_rename_args_t args;
} NASDMQ_edrfs_rename_msg_t;

typedef struct NASDMQ_edrfs_rename_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_rename_res_t res;
} NASDMQ_edrfs_rename_rep_t;

typedef struct NASDMQ_edrfs_getstats_msg_s {
  int seqnum;
  int replyq;
} NASDMQ_edrfs_getstats_msg_t;

typedef struct NASDMQ_edrfs_getstats_rep_s {
  nasd_rpc_status_t op_status;
  nasd_edrfs_getstats_res_t res;
} NASDMQ_edrfs_getstats_rep_t;

typedef struct NASDMQ_edrfs_resetstats_msg_s {
  int seqnum;
  int replyq;
} NASDMQ_edrfs_resetstats_msg_t;

typedef struct NASDMQ_edrfs_resetstats_rep_s {
  nasd_status_t nasd_status;
  nasd_rpc_status_t op_status;
} NASDMQ_edrfs_resetstats_rep_t;

/* message types */
#define NASD_EDRFS_MQ_BOGUS		0
#define NASD_EDRFS_MQ_MOUNT	1
#define NASD_EDRFS_MQ_FSSTAT	2
#define NASD_EDRFS_MQ_FSINFO	3
#define NASD_EDRFS_MQ_LOOKUP	4
#define NASD_EDRFS_MQ_READDIR	5
#define NASD_EDRFS_MQ_ACCESS	6
#define NASD_EDRFS_MQ_SETATTR	7
#define NASD_EDRFS_MQ_CREATE	8
#define NASD_EDRFS_MQ_SYMLINK	9
#define NASD_EDRFS_MQ_REMOVE	10
#define NASD_EDRFS_MQ_MKDIR	11
#define NASD_EDRFS_MQ_RMDIR	12
#define NASD_EDRFS_MQ_NEWCOOKIE	13
#define NASD_EDRFS_MQ_RENAME	14
#define NASD_EDRFS_MQ_GETSTATS	15
#define NASD_EDRFS_MQ_RESETSTATS 16
#define NASD_EDRFS_MQ_NULL	17
#define NASD_EDRFS_MQ_KICK	18

#define NASD_EDRFS_MQ_KEY		0x45445246 /* EDRF */

/* largest possible message */
#define NASD_EDRFS_MQ_MSGLEN	sizeof(nasd_edrfs_mq_buf_t)

typedef struct nasd_edrfs_mq_buf_s    nasd_edrfs_mq_buf_t;

struct nasd_edrfs_mq_buf_s {
  long mtype;                   /* this element is required by msg functions */
  union {
    NASDMQ_edrfs_null_msg_t       null_msg;
    NASDMQ_edrfs_null_rep_t       null_rep;
    NASDMQ_edrfs_mount_msg_t      mount_msg;
    NASDMQ_edrfs_mount_rep_t      mount_rep;
    NASDMQ_edrfs_fsstat_msg_t     fsstat_msg;
    NASDMQ_edrfs_fsstat_rep_t     fsstat_rep;
    NASDMQ_edrfs_fsinfo_msg_t     fsinfo_msg;
    NASDMQ_edrfs_fsinfo_rep_t     fsinfo_rep;
    NASDMQ_edrfs_lookup_msg_t     lookup_msg;
    NASDMQ_edrfs_lookup_rep_t     lookup_rep;
    NASDMQ_edrfs_readdir_msg_t    readdir_msg;
    NASDMQ_edrfs_readdir_rep_t    readdir_rep;
    NASDMQ_edrfs_access_msg_t     access_msg;
    NASDMQ_edrfs_access_rep_t     access_rep;
    NASDMQ_edrfs_setattr_msg_t    setattr_msg;
    NASDMQ_edrfs_setattr_rep_t    setattr_rep;
    NASDMQ_edrfs_create_msg_t     create_msg;
    NASDMQ_edrfs_create_rep_t     create_rep;
    NASDMQ_edrfs_symlink_msg_t    symlink_msg;
    NASDMQ_edrfs_symlink_rep_t    symlink_rep;
    NASDMQ_edrfs_remove_msg_t     remove_msg;
    NASDMQ_edrfs_remove_rep_t     remove_rep;
    NASDMQ_edrfs_mkdir_msg_t      mkdir_msg;
    NASDMQ_edrfs_mkdir_rep_t      mkdir_rep;
    NASDMQ_edrfs_rmdir_msg_t      rmdir_msg;
    NASDMQ_edrfs_rmdir_rep_t      rmdir_rep;
    NASDMQ_edrfs_newcookie_msg_t  newcookie_msg;
    NASDMQ_edrfs_newcookie_rep_t  newcookie_rep;
    NASDMQ_edrfs_rename_msg_t     rename_msg;
    NASDMQ_edrfs_rename_rep_t     rename_rep;
    NASDMQ_edrfs_getstats_msg_t   getstats_msg;
    NASDMQ_edrfs_getstats_rep_t   getstats_rep;
    NASDMQ_edrfs_resetstats_msg_t   resetstats_msg;
    NASDMQ_edrfs_resetstats_rep_t   resetstats_rep;
  } un;
};

#endif /* !_NASD_EDRFS_MQ_H_ */
