/*
 * nasd_msg.h
 *
 * NASD message queue functions
 *
 * Authors: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_MSG_H_
#define _NASD_MSG_H_

#include <nasd/nasd_options.h>

#ifndef KERNEL
#include <sys/ipc.h>
#include <sys/msg.h>

/* For now, just define these as wrappers around the real functions. */

#define nasd_msg_msgget(key, msgflg) \
        msgget(key, msgflg)
#define nasd_msg_msgsnd(msqid, msgp, msgsz, msgflg) \
        msgsnd(msqid, msgp, msgsz, msgflg)
#define nasd_msg_msgrcv(msqid, msgp, msgsz, msgtyp, msgflg) \
        msgrcv(msqid, msgp, msgsz, msgtyp, msgflg)
#endif /* !KERNEL */

#endif /* !_NASD_MSG_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
