/*
 * nasd_nonce_mgmt.h
 *
 * Handle checking if a nonce is fresh or resued
 *
 * Author: Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_NONCE_MGMT_H
#define _NASD_NONCE_MGMT_H

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_general.h>
#include <nasd/nasd_threadstuff.h>

/* How close to current time a nonce timestamp must be for us to even
   look at it. */
#define NASD_SKEW_SECS 			nasd_int64cast(10)
#define NASD_ACCEPTABLE_SKEW		(NASD_NSEC_PER_SEC*NASD_SKEW_SECS)

typedef struct nasd_sec_nonce_bucket_s  nasd_sec_nonce_bucket_t;
typedef struct nasd_sec_nonce_mgr_s     nasd_sec_nonce_mgr_t;
typedef struct nasd_sec_nonce_ent_s     nasd_sec_nonce_ent_t;

struct nasd_sec_nonce_mgr_s {
  int                       nasd_sec_nonce_nbuckets;
  nasd_sec_nonce_bucket_t  *nasd_sec_recent_nonces;
};

/* a nonce hash table entry */
struct nasd_sec_nonce_ent_s {
  nasd_uint64 time;
  nasd_identifier_t ni;
  nasd_int32 expiration;
  nasd_key_t key;
  nasd_sec_nonce_ent_t *next;
  nasd_sec_nonce_ent_t *prev;
};

/* a nonce hash table bucket */
struct nasd_sec_nonce_bucket_s {
  NASD_DECLARE_MUTEX(lock)
  nasd_sec_nonce_ent_t *head;	/* first item in bucket */
  int size;			/* number of items in bucket */
};

nasd_status_t nasd_sec_real_init_nonce(void);
void nasd_sec_nonce_sysinit(void);
nasd_status_t nasd_sec_init_nonce(void);
void nasd_sec_real_shutdown_nonce(void);
void nasd_sec_shutdown_nonce(void *ignored);
nasd_status_t nasd_sec_check_nonce(
				   nasd_sec_nonce_mgr_t *mgr,
				   nasd_capability_t *capability,
				   nasd_byte_t *cap_key,
				   nasd_timespec_t *nonce,
				   nasd_timespec_t *now);
nasd_status_t nasd_sec_nonce_mgr_init(
				   nasd_sec_nonce_mgr_t **mgrp,
				   int table_size);
void nasd_sec_nonce_mgr_destroy(
				   nasd_sec_nonce_mgr_t *mgr);
void nasd_sec_nonce_mgr_shutdown(
				   void *mgr_arg);

#endif /* !_NASD_NONCE_MGMT_H */
