/*
 * nasd_pdrive_client_srpc.h
 *
 * defs/structs used by SRPC clients of NASD drives
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_PDRIVE_CLIENT_SRPC_H_
#define _NASD__NASD_PDRIVE_CLIENT_SRPC_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_pdrive.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_drive_types.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct nasd_drive_handle_srpc_s {
  nasd_srpc_handle_t  h;
} nasd_drive_handle_srpc_t;

extern nasd_status_t nasd_cl_srpc_init(nasd_shutdown_list_t *sl);

extern void nasd_cl_srpc_null_dr(nasd_drive_handle_t handle,
  nasd_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_sync_dr(nasd_drive_handle_t handle,
  nasd_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_part_creat_dr(nasd_drive_handle_t handle,
  nasd_key_t in_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_part_creat_dr_args_t *args,
  nasd_p_part_creat_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_create_dr__otw_provided(
  nasd_drive_handle_t handle, nasd_key_t req_key,
  nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_create_dr_args_t *args,
  nasd_p_create_dr_res_t *res,
  nasd_cl_p_otw_buf_t *otw,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_getattr_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_getattr_dr_args_t *args,
  nasd_p_getattr_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_range_write_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_smpl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastwrite_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_write_simple_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_smpl_op_dr_args_t *args, void *buf, 
  nasd_p_fastwrite_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_read_simple_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_smpl_op_dr_args_t *args,
  void *buf, nasd_p_fastread_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_tread_simple_dr(nasd_drive_handle_t handle, 
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_thrtl_op_dr_args_t *args,
  void *buf, nasd_p_fastread_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_range_read_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_smpl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastread_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_range_tread_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_thrtl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastread_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_setattr_dr__otw_provided(
  nasd_drive_handle_t handle, nasd_key_t req_key,
  nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_setattr_dr_args_t *args,
  nasd_p_setattr_dr_res_t *res,
  nasd_cl_p_otw_buf_t *otw,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_flush_obj_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_flush_obj_dr_args_t *args, 
  nasd_p_flush_obj_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_eject_obj_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_eject_obj_dr_args_t *args, 
  nasd_p_eject_obj_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_remove_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_remove_dr_args_t *args,
  nasd_p_remove_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_initialize_dr(nasd_drive_handle_t handle,
  nasd_p_initialize_dr_args_t *args, nasd_p_initialize_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_strt_iread_dr(nasd_drive_handle_t handle,
  nasd_key_t in_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_strt_iread_dr_args_t *args,
  nasd_p_strt_iread_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_stop_iread_dr(nasd_drive_handle_t handle,
  nasd_key_t in_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_stop_iread_dr_args_t *args,
  nasd_p_stop_iread_dr_res_t *res,
  nasd_rpc_status_t *status);

extern void nasd_cl_srpc_rshutdown_dr(nasd_drive_handle_t handle,
  nasd_key_t in_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_rshutdown_dr_args_t *args,
  nasd_p_rshutdown_dr_res_t *res, nasd_rpc_status_t *status);

extern void nasd_cl_srpc_error_string(nasd_drive_handle_t handle,
  nasd_rpc_status_t status, nasd_error_string_t str,
  char *file, int line);

extern void nasd_cl_p_srpc_register(int counter_lock_held);

#endif /* !_NASD__NASD_PDRIVE_CLIENT_SRPC_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
