/*
 * nasd_platform.h
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_PLATFORM_H_
#define _NASD__NASD_PLATFORM_H_

#include <nasd/nasd_options.h>

#ifdef DEC_OSF
#include <nasd/dux/nasd_dux_platform.h>
#endif /* DEC_OSF */

#ifdef LINUX
#include <nasd/linux/nasd_linux_platform.h>
#endif /* LINUX */

#ifdef IRIX
#include <nasd/irix/nasd_irix_platform.h>
#endif /* IRIX */

#ifdef SOLARIS
#include <nasd/solaris/nasd_solaris_platform.h>
#endif /* SOLARIS */

#ifdef FREEBSD
#include <nasd/freebsd/nasd_freebsd_platform.h>
#endif /* FREEBSD */

#if __GNUC__ && !defined(KERNEL)
/* This is necessary because parts of Cheops use "asm" as a variable
   name.  That conflicts with gcc's use of "asm" as a reserved word.
   This was easier than changing all the parts of Cheops that use "asm"
   as a variable.
   
   Since Cheops doesn't run in the Linux kernel currently and various
   bits of kernel code really do want to use assembly, we don't have to
   do this when KERNEL is defined.
*/
#define asm			asm_the_variable
#endif /* __GNUC__ && !KERNEL */

#define nasd_idcast(_id_) nasd_uint64cast(_id_)

#endif /* !_NASD__NASD_PLATFORM_H_ */
