/*
 * nasd_shell.h
 *
 * NASD-shell definitions shared across shell and
 * loadable modules
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_SHELL_H_
#define _NASD__NASD_SHELL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_varargs.h>

#define NASD_SHELL_MAJOR_VERS 1
#define NASD_SHELL_MINOR_VERS 0

typedef struct nasd_shell_action_s    nasd_shell_action_t;
typedef struct nasd_shell_variable_s  nasd_shell_variable_t;

typedef nasd_status_t (*nasd_shell_action_proc_t)(
  char  **args,
  int     nargs);

#define NASD_SHELL_VAR_TYPE_STRING    0

#define NASD_SHELL_VAR_FLAG_NONE      0
#define NASD_SHELL_VAR_FLAG_RO    (1<<0) /* readonly */

struct nasd_shell_action_s {
  char                      *name;
  nasd_shell_action_proc_t   proc;
};

struct nasd_shell_variable_s {
  char                      *name;
  int                        type;
  int                        flags;
  nasd_shell_action_proc_t   change_proc;
  void                      *addr;
};

extern void nasd_shell_shutdown(int code);
extern nasd_status_t nasd_shell_add_var(nasd_shell_variable_t *var);
extern nasd_status_t nasd_shell_add_action(nasd_shell_action_t *act);

extern void nasd_shell_warn NASD_VARARGS_PROTO((char *fmt, ...));
extern void nasd_shell_output NASD_VARARGS_PROTO((char *fmt, ...));
extern void nasd_shell_flush_output(void);

#endif /* !_NASD__NASD_SHELL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
