/*
 * nasd_rpcgen.h
 *
 * Global declarations, prototypes, etc for nasd_rpcgen
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_RPCGEN_H_
#define _NASD_RPCGEN_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_general_simple.h>
#include <nasd/nasd_rpcgen_c.h>
#include <sys/param.h>

#define NASD_RPCGEN_PATHSEP '/'

typedef  struct nasd_rpcgen_call_s          nasd_rpcgen_call_t;
typedef  struct nasd_rpcgen_comp_result_s   nasd_rpcgen_comp_result_t;
typedef  struct nasd_rpcgen_const_s         nasd_rpcgen_const_t;
typedef  struct nasd_rpcgen_cpparg_s        nasd_rpcgen_cpparg_t;
typedef  struct nasd_rpcgen_decl_s          nasd_rpcgen_decl_t;
typedef  struct nasd_rpcgen_fhandle_s       nasd_rpcgen_fhandle_t;
typedef  struct nasd_rpcgen_filename_s      nasd_rpcgen_filename_t;
typedef  struct nasd_rpcgen_global_spec_s   nasd_rpcgen_global_spec_t;
typedef  struct nasd_rpcgen_global_val_s    nasd_rpcgen_global_val_t;
typedef  struct nasd_rpcgen_import_s        nasd_rpcgen_import_t;
typedef  struct nasd_rpcgen_marshall_s      nasd_rpcgen_marshall_t;
typedef  struct nasd_rpcgen_namehash_s      nasd_rpcgen_namehash_t;
typedef  struct nasd_rpcgen_namehash_ent_s  nasd_rpcgen_namehash_ent_t;
typedef  struct nasd_rpcgen_type_s          nasd_rpcgen_type_t;
typedef  struct nasd_rpcgen_val_s           nasd_rpcgen_val_t;

#define NASD_RPCGEN_MAX_LINE_LEN  4096
#define NASD_RPCGEN_MAX_ARRDIM       8

#define NASD_RPCGEN_DIR_IN       1
#define NASD_RPCGEN_DIR_OUT      2

#define NASD_RPCGEN_TYPE_INT8      1
#define NASD_RPCGEN_TYPE_UINT8     2
#define NASD_RPCGEN_TYPE_INT16     3
#define NASD_RPCGEN_TYPE_UINT16    4
#define NASD_RPCGEN_TYPE_INT32     5
#define NASD_RPCGEN_TYPE_UINT32    6
#define NASD_RPCGEN_TYPE_INT64     7
#define NASD_RPCGEN_TYPE_UINT64    8
#define NASD_RPCGEN_TYPE_DERIVED   9
#define NASD_RPCGEN_TYPE_ARRAY    10
#define NASD_RPCGEN_TYPE_STRUCT   11
#define NASD_RPCGEN_TYPE_STRING   12
#define NASD_RPCGEN_TYPE_PIPE     13
#define NASD_RPCGEN_TYPE_FLOAT    14
#define NASD_RPCGEN_TYPE_DOUBLE   15

#define NASD_RPCGEN_DECL_TYPE           1
#define NASD_RPCGEN_DECL_IMPORT         2
#define NASD_RPCGEN_DECL_CONST          3
#define NASD_RPCGEN_DECL_STRUCT         4
#define NASD_RPCGEN_DECL_CALL           5
#define NASD_RPCGEN_DECL_UUID           6
#define NASD_RPCGEN_DECL_DCE_ENDPOINT   7
#define NASD_RPCGEN_DECL_VERSION        8
#define NASD_RPCGEN_DECL_MARSHALL       9
#define NASD_RPCGEN_DECL_BASEID        10

#define NASD_RPCGEN_NAMEHASH_BUCKETS 15

#define NASD_RPCGEN_OK        0
#define NASD_RPCGEN_DUP_ENT   1
#define NASD_RPCGEN_BAD_EXPR  2
#define NASD_RPCGEN_BAD_KEY   3

#define NASD_RPCGEN_NAMEHASH_OVERRIDE    0x0001
#define NASD_RPCGEN_NAMEHASH_CLONEKEY    0x0002
#define NASD_RPCGEN_NAMEHASH_NODIGIT     0x0004
#define NASD_RPCGEN_NAMEHASH_PUNCTOK     0x0008

#define NASD_RPCGEN_LEX_BRACE_EXPR 0x0001

#define NASD_RPCGEN_OUT_FLAGS_WRITTEN   0x0001
#define NASD_RPCGEN_OUT_FLAGS_MARSHALL  0x0002

struct nasd_rpcgen_cpparg_s {
  char                  *arg;
  nasd_rpcgen_cpparg_t  *next;
};

struct nasd_rpcgen_decl_s {
  int                  decl_type;
  void                *decl;
  char                *define_file;
  int                  define_line;
  nasd_rpcgen_decl_t  *gnext;
  nasd_rpcgen_decl_t  *gprev;
};

struct nasd_rpcgen_val_s {
  char                *str;
  nasd_rpcgen_uint32   u32;
  nasd_rpcgen_decl_t   decl;
};

struct nasd_rpcgen_global_val_s {
  nasd_rpcgen_val_t  uuid;
  nasd_rpcgen_val_t  dce_endpoint;
  nasd_rpcgen_val_t  version;
  nasd_rpcgen_val_t  baseid;
};

struct nasd_rpcgen_filename_s {
  char                    *filename;
  nasd_rpcgen_filename_t  *next;
};

struct nasd_rpcgen_import_s {
  char                  *filename;
  nasd_rpcgen_decl_t     decl;
  nasd_rpcgen_import_t  *gnext;
  nasd_rpcgen_import_t  *gprev;
};

struct nasd_rpcgen_namehash_ent_s {
  char                        *key;
  int                          len;
  void                        *rock;
  nasd_rpcgen_namehash_ent_t  *next;
};

struct nasd_rpcgen_namehash_s {
  nasd_rpcgen_namehash_ent_t  *buckets[NASD_RPCGEN_NAMEHASH_BUCKETS];
};

struct nasd_rpcgen_comp_result_s {
  nasd_rpcgen_int64   result_s;
  nasd_rpcgen_uint64  result_u;
};

struct nasd_rpcgen_const_s {
  char                 *name;
  nasd_rpcgen_type_t   *type;
  nasd_rpcgen_type_t   *base_type;
  int                   import_level;
  nasd_rpcgen_decl_t    decl;
  union {
    nasd_rpcgen_int8     val_int8;
    nasd_rpcgen_uint8    val_uint8;
    nasd_rpcgen_int16    val_int16;
    nasd_rpcgen_uint16   val_uint16;
    nasd_rpcgen_int32    val_int32;
    nasd_rpcgen_uint32   val_uint32;
    nasd_rpcgen_int64    val_int64;
    nasd_rpcgen_uint64   val_uint64;
    float                val_float;
    double               val_double;
    char                *val_str;
  } val;
  nasd_rpcgen_const_t  *gnext;
  nasd_rpcgen_const_t  *gprev;
};

struct nasd_rpcgen_call_s {
  char                    *name;
  int                      import_level;
  nasd_rpcgen_decl_t       decl;
  nasd_rpcgen_namehash_t  *call_elems;
  nasd_rpcgen_type_t      *call_args;
  nasd_rpcgen_type_t      *call_list;
  nasd_rpcgen_type_t      *call_list_tail;
  nasd_rpcgen_call_t      *gnext;
  nasd_rpcgen_call_t      *gprev;
};

struct nasd_rpcgen_type_s {
  char                    *name;
  char                    *dceidl_name;
  char                    *c_name;
  int                      type_is;
  int                      nelements[NASD_RPCGEN_MAX_ARRDIM];
  int                      ndim;
  int                      size;
  int                      min_align;
  int                      import_level;
  int                      call_dir;
  int                      out_flags;
  int                      nomarshall;
  int                      ispad;
  int                      is_typem;
  nasd_rpcgen_decl_t       decl;
  nasd_rpcgen_namehash_t  *struct_elems;
  nasd_rpcgen_type_t      *first_typedef;
  nasd_rpcgen_type_t      *derived_from;
  nasd_rpcgen_type_t      *struct_next;
  nasd_rpcgen_type_t      *call_next;
  nasd_rpcgen_type_t      *struct_list;
  nasd_rpcgen_type_t      *struct_list_tail;
  nasd_rpcgen_type_t      *gnext;
  nasd_rpcgen_type_t      *gprev;
  nasd_rpcgen_type_t      *m_orig_type;
};

struct nasd_rpcgen_marshall_s {
  nasd_rpcgen_type_t      *type;
  nasd_rpcgen_decl_t       decl;
  int                      import_level;
  nasd_rpcgen_marshall_t  *gnext;
  nasd_rpcgen_marshall_t  *gprev;
};

struct nasd_rpcgen_global_spec_s {
  nasd_rpcgen_filename_t   *usc_import_list;
  nasd_rpcgen_filename_t   *usc_import_list_tail;
  int                       annotate;
  int                       min_alignment;
  int                       pad_to;
  int                       max_parse_errors;
  int                       allow_keyword_dup; /* uuid, dce-endpoint, etc */
  int                       array_thresh;
  char                     *base_import_path;
  char                     *c_header_output_filename;
  char                     *srpc_glob_header_output_filename;
  char                     *dce_idl_output_filename;
  char                     *old_marshall_types_c_output_filename;
  char                     *marshall_types_c_output_filename;
  char                     *marshall_types_h_output_filename;
  char                     *net_convert_h_output_filename;
  char                     *net_convert_h_output_filename_nooutput;
  char                     *server_c_output_filename;
  char                     *server_h_output_filename;
  char                     *client_c_output_filename;
  char                     *client_h_output_filename;
  char                     *usc_output_filename;
  char                     *input_filename;
  char                     *std_prefix;
  char                     *std_suffix;
  char                     *out_if_name;
  char                    **extra_inputs;
  int                       nextra_inputs;
};

struct nasd_rpcgen_fhandle_s {
  FILE  *f;
  char   line_copy[NASD_RPCGEN_MAX_LINE_LEN];
  char   cur_filename[MAXPATHLEN];
  int    cur_line;
};

#define nasd_rpcgen_ismath(_c_) \
 ((((_c_) >= '0') && ((_c_) <= '9')) \
  || ((_c_) == '(') || ((_c_) == ')') \
  || ((_c_) == '+') || ((_c_) == '-') \
  || ((_c_) == '*') || ((_c_) == '/'))

/* nasd_rpcgen.c */
extern int verbose;
extern char *progname;
extern char *cpp_cmd;
extern char *cpp_path;
extern nasd_rpcgen_cpparg_t *cppargs, *cppargs_tail;
extern nasd_rpcgen_cpparg_t *searchdirs, *searchdirs_tail;
extern nasd_rpcgen_global_spec_t global_spec;
extern FILE *oerr;
extern void str_append_prefix(char *str, char *infix, char **outp);
extern void str_prepend_suffix(char *str, char *infix, char **outp);
extern void compute_out_if_name(char *filename);
extern void output_cpp_comment_header(FILE *f, char *filename);
extern void output_error(void);
extern void usage(void);
extern int is_power_two(nasd_rpcgen_uint64 val);

/* nasd_rpcgen_cpp.c */
extern void nasd_cpp_flush(nasd_rpcgen_fhandle_t *fhandle);
extern int nasd_cpp_fopen(char *filename,
  nasd_rpcgen_fhandle_t *fhandle);
extern char *nasd_cpp_fgets(char *str, int len,
  nasd_rpcgen_fhandle_t *fhandle);
extern void nasd_cpp_fclose(nasd_rpcgen_fhandle_t *fhandle);

/* nasd_rpcgen_math.c */
extern int parse_func_math(nasd_rpcgen_fhandle_t *fhandle,
  char *str, char **extra_words,
  int extra_word_count, nasd_rpcgen_int64 *result_s,
  nasd_rpcgen_uint64 *result_u);

/* nasd_rpcgen_output_c.c */
extern void output_c_header(char *filename);
extern void output_srpc_glob_header(char *filename);
extern void output_c_server_c(char *filename);
extern void output_c_server_h(char *filename);
extern void output_c_client_c(char *filename);
extern void output_c_client_h(char *filename);

/* nasd_rpcgen_output_dceidl.c */
extern void output_dce_idl(char *filename);

/* nasd_rpcgen_output_usc.c */
extern void output_net_convert_h(char *filename);
extern void output_usc(char *filename);

/* nasd_rpcgen_output_marshall.c */
extern void output_marshall_h(char *filename);
extern void output_old_marshall_c(char *filename);
extern void output_marshall_c(char *filename);

/* nasd_rpcgen_parse.c */
extern int import_level;
extern int nparse_errors;
extern FILE *pserr;
extern char **lex_line(char *s, int *count, int bracelev,
  nasd_rpcgen_fhandle_t *fhandle);
extern void parse_error(void);
extern int global_val_str(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count, nasd_rpcgen_val_t *strval,
  char *valname, int decl_type);
extern void parse_input_file(char *filename, int search_path);
extern void global_uuid(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_dce_endpoint(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_version(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_marshall(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_const(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void see_uniq(char *str);
extern int have_seen_uniq(char *str);
extern void global_import(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_type(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void absorb_bad_struct(nasd_rpcgen_fhandle_t *fhandle);
extern void absorb_bad_call(nasd_rpcgen_fhandle_t *fhandle);
extern void global_struct(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern void global_call(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern nasd_rpcgen_type_t *parse_type(nasd_rpcgen_fhandle_t *fhandle,
  char **words, int count);
extern int parse_val(nasd_rpcgen_fhandle_t *fhandle,
  char *str, char **extra_words,
  int extra_word_count, nasd_rpcgen_int64 *result_s,
  nasd_rpcgen_uint64 *result_u);
extern int parse_func_size(nasd_rpcgen_fhandle_t *fhandle,
  char *str, char **extra_words,
  int extra_word_count, nasd_rpcgen_int64 *result_s,
  nasd_rpcgen_uint64 *result_u);
extern int parse_func(nasd_rpcgen_fhandle_t *fhandle,
  char *funcstr, char *str, char **extra_words,
  int extra_word_count, nasd_rpcgen_int64 *result_s,
  nasd_rpcgen_uint64 *result_u);

/* nasd_rpcgen_tab.c */
extern nasd_rpcgen_namehash_t *global_type_hash;
extern nasd_rpcgen_namehash_t *global_const_hash;
extern nasd_rpcgen_namehash_t *global_struct_hash;
extern nasd_rpcgen_namehash_t *import_seen_hash;
extern nasd_rpcgen_namehash_t *uniq_seen_hash;
extern nasd_rpcgen_namehash_t *global_call_hash;
extern nasd_rpcgen_namehash_t *global_marshall_hash;
extern nasd_rpcgen_type_t *pad_type;
extern nasd_rpcgen_global_val_t global_vals;
extern nasd_rpcgen_const_t global_consts;
extern nasd_rpcgen_type_t global_types;
extern nasd_rpcgen_import_t global_imports;
extern nasd_rpcgen_call_t global_calls;
extern nasd_rpcgen_decl_t global_decls;
extern nasd_rpcgen_marshall_t global_marshalls;
extern int strhash(char *key);
extern void strclone(char *src, char **dext);
extern void init_tables(void);
extern void init_basic_types(void);
extern int nasd_rpcgen_namehash_add(nasd_rpcgen_namehash_t *nh,
  char *key, void *rock, int flags, void *dup_rockp);
extern void nasd_rpcgen_namehash_lookup(nasd_rpcgen_namehash_t *nh,
  char *key, void *rockp);
extern nasd_rpcgen_cpparg_t *nasd_rpcgen_cpparg_get(void);
extern nasd_rpcgen_namehash_t *nasd_rpcgen_namehash_get(void);
extern nasd_rpcgen_namehash_ent_t *nasd_rpcgen_namehash_ent_get(void);
extern nasd_rpcgen_decl_t *nasd_rpcgen_decl_get(void);
extern nasd_rpcgen_type_t *nasd_rpcgen_type_get(void);
extern nasd_rpcgen_const_t *nasd_rpcgen_const_get(void);
extern nasd_rpcgen_import_t *nasd_rpcgen_import_get(void);
extern nasd_rpcgen_marshall_t *nasd_rpcgen_marshall_get(void);
extern nasd_rpcgen_filename_t *nasd_rpcgen_filename_get(void);
extern nasd_rpcgen_call_t *nasd_rpcgen_call_get(void);
extern nasd_rpcgen_type_t *lookup_type(char *name);
extern nasd_rpcgen_type_t *lookup_struct(char *name);
extern nasd_rpcgen_const_t *lookup_const(char *name);
extern nasd_rpcgen_call_t *lookup_call(char *name);
extern int add_global_type(nasd_rpcgen_type_t *type,
  nasd_rpcgen_type_t **dupp);
extern int add_global_const(nasd_rpcgen_const_t *cnst,
  nasd_rpcgen_const_t **dupp);
extern int add_global_call(nasd_rpcgen_call_t *call,
  nasd_rpcgen_call_t **dupp);
extern int add_global_marshall(nasd_rpcgen_marshall_t *marshall,
  nasd_rpcgen_marshall_t **dupp);
extern void add_global_decl(nasd_rpcgen_decl_t *decl);
extern nasd_rpcgen_type_t *basic_type_of(nasd_rpcgen_type_t *type);
extern nasd_rpcgen_type_t *basic_type_of_extended(nasd_rpcgen_type_t *type);
extern void reset_output_bits(void);

#endif /* !_NASD_RPCGEN_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
