/* $Header: /home/agc/src/ssam-1.9/RCS/ssam.h,v 1.16 1997/10/20 15:35:00 agc Exp $ */

/*
 * Copyright © 1996-1997 Alistair G. Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Alistair G. Crooks.
 * 4. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef SSAM_H_
#define SSAM_H_

#include <config.h>

#ifdef HAVE_SETJMP_H
#include <setjmp.h>
#endif

#include <ure.h>

#ifndef SSAM_VERSION_STRING
#define SSAM_VERSION_STRING	"1.9"
#endif

#ifndef SSAM_AUTHOR_STRING
#define SSAM_AUTHOR_STRING	"Alistair G. Crooks (agc@netbsd.org)"
#endif

/* Flags for ssam */
enum {
	Writeable = 0x01,
	Explain = 0x02,
	NoEcho = 0x04,
	ByteOffsets = 0x08
};

/* Flags for ssamfree */
enum {
	CloseFiles = 0x01,
	FreeCommands = 0x02,
	FreeChanges = 0x04,
	FreeFiles = 0x08,
	FreeMatches = 0x10
};

/* Constants for Buffer Gap routines */
enum {
	BGByte,
	BGChar,
	BGLine,

	BGFromBOF,
	BGFromHere,
	BGFromEOF
};

/* Generic Command types - used in gc_cmdtype */
enum {
	Cmd,
	SimpleAddr,
	CompoundAddr
};

/* a macro to encapsulate the above constants */
#define ISADDRESS(gp)	\
	((gp)->gc_cmdtype == SimpleAddr || (gp)->gc_cmdtype == CompoundAddr)

/* max # of args a ssam command can have */
enum {
	MaxCmdArgs = 2
};

/* Error constants */
enum {
	ErrUnknown,
	ErrNoCmd,
	ErrNothingToDo,
	ErrNoTarget,
	ErrNoSubcommand,
	ErrInvalidAddr,
	ErrBadURE,
	ErrBadFilespec,
	ErrBadLineNumber,
	ErrChangeStack,
	ErrCantWrite,
	ErrBlockUnderflow,
	ErrBlockOverflow,
	LastError
};

/* a range of offsets in a file - note that these are longs */
typedef struct range {
	long	r_from;		/* Beginning of range */
	long	r_to;		/* End of range */
} range_t;

/* this struct describes a file in memory */
typedef struct f {
	char	*f_name;	/* file name - perhaps null */
	char	f_modified;	/* file has been modified */
	char	f_writeme;	/* write file at end of changes */
	char	f_dirty;	/* pending changes to this file */
	long	f_size;		/* size of file */
	char	*f_buf;		/* buffer-gap buffer */
	range_t	f_r;		/* current range */
	long	f_abc;		/* # of bytes after the gap */
	long	f_bbc;		/* # of bytes before the gap */
	long	f_acc;		/* # of utf chars after the gap */
	long	f_bcc;		/* # of utf chars before the gap */
	long	f_alc;		/* # of records after the gap */
	long	f_blc;		/* # of records before the gap */
} f_t;

/* this struct describes a part of a file */
typedef struct context {
	f_t	*c_fp;		/* file */
	range_t	c_r;		/* the range */
} context_t;

/* this structure describes a modification */
typedef struct change {
	f_t	*ch_fp;		/* file */
	range_t	ch_r;		/* range to be modified */
	char	ch_type;	/* type of modification delete or insert */
	int	ch_c;		/* # of chars in insertion */
	char	*ch_v;		/* the chars to insert */
} change_t;

/* this encapsulates various variables for the ssam commands */
typedef struct ssam {
	context_t	s_mark;		/* context saved in 'k' command */
	int		s_blockc;	/* block count */
	char		*s_collseq;	/* collation sequence */
	context_t	s_dot;		/* sam's context */
	int		s_chgc;		/* # of changes */
	int		s_chgsize;	/* size of change array */
	change_t	*s_chgv;	/* change array */
	int		s_progsize;	/* size of command array below */
	int		s_progc;	/* count of commands in command array */
	struct cmd	*s_progv;	/* the commands themselves */
	f_t		**s_fv;		/* the files */
	int		s_fc;		/* # of files */
	int		s_fsize;	/* size of fv array */
	f_t		*s_fcurr;	/* current file */
	int		s_outbytes;	/* output byte offsets */
	int		s_matchc;	/* current offset of match subscript */
	int		s_matchsize;	/* size of match array */
	urematch_t	*s_matchv;	/* match array */
	jmp_buf		s_escape;	/* non-local goto for escape purposes */
} ssam_t;

/* this struct describes a generic command */
typedef struct gcmd {
	Rune	gc_ch;		/* character which triggers the command/addr */
	int	(*gc_func)(ssam_t *sp, context_t *dot, int *cmdp);
	int	gc_argc;	/* # of args to command */
	int	gc_tgt;		/* command has a target */
	int	gc_subcmd;	/* command has a sub-command */
	int	gc_compile;	/* first arg is a ure to be compiled */
	int	gc_advance;	/* advance the parser */
	int	gc_getint;	/* get an integer into iargv[0] */
	int	gc_recblock;	/* recognise a block */
	int	gc_cmdtype;	/* command type */
	char	*gc_lhs;	/* default lhs */
	char	*gc_rhs;	/* default rhs */
	int	gc_blockc;	/* block count */
	int	gc_intesc;	/* interpret escape sequences in first arg */
} gcmd_t;

/* this structure describes a single sam command */
typedef struct cmd {
	char	*c_line;	/* pointer to start of command line */
	int	c_pos;		/* position in command line */
	gcmd_t	*c_gcp;		/* generic command description */
	char	*c_argv[MaxCmdArgs];	/* the start of the args */
	int	c_iargv[MaxCmdArgs];	/* the length of the args */
	ure_t	c_u;		/* compiled ure */
	int	c_next;		/* next command */
	int	c_lhs;		/* any lhs to command */
	int	c_rhs;		/* any rhs to command */
	int	c_sub;		/* any sub command */
	int	c_tgt;		/* target of command */
} cmd_t;

/* prototype functions */
int ssamfiles(ssam_t *sp, int argc, char **argv);
int ssam(ssam_t *sp, char *command, int argc, int flags, char *collseq);
int ssamcommit(ssam_t *sp, int argc, int flags);
void ssamfree(ssam_t *sp, int flags);

#endif /* !SSAM_H_ */
