; -*- coding: iso-2022-7bit  -*-
;;; u-cns-6.el --- tables between UCS and CNS 11643:1992 plain 6

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-6 'unicode-assoc
     'cns11643-6-vs-unicode-assoc)

(defvar cns11643-6-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(L!#(B . "0x4E44") ; <CJK>
       (?$(L!-(B . "0x536B") ; <CJK>
       (?$(L!1(B . "0x4E38") ; <CJK>
       (?$(L!8(B . "0x5203") ; <CJK>
       (?$(L!P(B . "0x5185") ; <CJK>
       (?$(L!a(B . "0x53CA") ; <CJK>
       (?$(L"F(B . "0x5305") ; <CJK>
       (?$(L"[(B . "0x53EB") ; <CJK>
       (?$(L#R(B . "0x5145") ; <CJK>
       (?$(L#l(B . "0x6530") ; <CJK>
       (?$(L%#(B . "0x6B21") ; <CJK>
       (?$(L%R(B . "0x828B") ; <CJK>
       (?$(L&N(B . "0x5438") ; <CJK>
       (?$(L&g(B . "0x575A") ; <CJK>
       (?$(L'!(B . "0x5BFF") ; <CJK>
       (?$(L'6(B . "0x5DE1") ; <CJK>
       (?$(L'C(B . "0x5E94") ; <CJK>
       (?$(L'_(B . "0x5FCD") ; <CJK>
       (?$(L(.(B . "0x6753") ; <CJK>
       (?$(L)'(B . "0x829D") ; <CJK>
       (?$(L)((B . "0x82B1") ; <CJK>
       (?$(L*!(B . "0x5365") ; <CJK>
       (?$(L+`(B . "0x62E8") ; <CJK>
       (?$(L+c(B . "0x62B1") ; <CJK>
       (?$(L,[(B . "0x6CBF") ; <CJK>
       (?$(L-E(B . "0x76F4") ; <CJK>
       (?$(L-i(B . "0x80B2") ; <CJK>
       (?$(L."(B . "0x82BD") ; <CJK>
       (?$(L.#(B . "0x82E6") ; <CJK>
       (?$(L.$(B . "0x82E5") ; <CJK>
       (?$(L/%(B . "0x52C7") ; <CJK>
       (?$(L/8(B . "0x5351") ; <CJK>
       (?$(L1m(B . "0x5192") ; <CJK>
       (?$(L1r(B . "0x6804") ; <CJK>
       (?$(L2B(B . "0x6D3E") ; <CJK>
       (?$(L2H(B . "0x70AD") ; <CJK>
       (?$(L4G(B . "0x8650") ; <CJK>
       (?$(L4`(B . "0x8FEC") ; <CJK>
       (?$(L5X(B . "0x52C9") ; <CJK>
       (?$(L5x(B . "0x53DE") ; <CJK>
       (?$(L5~(B . "0x5510") ; <CJK>
       (?$(L65(B . "0x57CE") ; <CJK>
       (?$(L6W(B . "0x5A30") ; <CJK>
       (?$(L6f(B . "0x5BB2") ; <CJK>
       (?$(L86(B . "0x66F8") ; <CJK>
       (?$(L8t(B . "0x6D78") ; <CJK>
       (?$(L9-(B . "0x6D69") ; <CJK>
       (?$(L:-(B . "0x771F") ; <CJK>
       (?$(L:C(B . "0x79EB") ; <CJK>
       (?$(L;!(B . "0x8038") ; <CJK>
       (?$(L;$(B . "0x8081") ; <CJK>
       (?$(L;:(B . "0x81F4") ; <CJK>
       (?$(L<;(B . "0x8D77") ; <CJK>
       (?$(L>P(B . "0x5A66") ; <CJK>
       (?$(L>v(B . "0x5D2B") ; <CJK>
       (?$(L@+(B . "0x6383") ; <CJK>
       (?$(L@6(B . "0x6368") ; <CJK>
       (?$(L@X(B . "0x671B") ; <CJK>
       (?$(LD;(B . "0x8457") ; <CJK>
       (?$(LD<(B . "0x83CC") ; <CJK>
       (?$(LD=(B . "0x83DC") ; <CJK>
       (?$(LD>(B . "0x83CA") ; <CJK>
       (?$(LDp(B . "0x8A24") ; <CJK>
       (?$(LE8(B . "0x8DC3") ; <CJK>
       (?$(LF>(B . "0x9EBB") ; <CJK>
       (?$(LFe(B . "0x51F2") ; <CJK>
       (?$(LFg(B . "0x5272") ; <CJK>
       (?$(LFt(B . "0x535A") ; <CJK>
       (?$(LG)(B . "0x55B6") ; <CJK>
       (?$(LG*(B . "0x5584") ; <CJK>
       (?$(LG1(B . "0x55AB") ; <CJK>
       (?$(LGV(B . "0x5962") ; <CJK>
       (?$(LG{(B . "0x5C60") ; <CJK>
       (?$(LH+(B . "0x5D43") ; <CJK>
       (?$(LH7(B . "0x5DFD") ; <CJK>
       (?$(LH<(B . "0x5E3D") ; <CJK>
       (?$(LHE(B . "0x5EC3") ; <CJK>
       (?$(LIx(B . "0x6700") ; <CJK>
       (?$(LJe(B . "0x6E2F") ; <CJK>
       (?$(LKV(B . "0x7570") ; <CJK>
       (?$(LL/(B . "0x7861") ; <CJK>
       (?$(LLC(B . "0x7A06") ; <CJK>
       (?$(LLH(B . "0x7A01") ; <CJK>
       (?$(LMG(B . "0x8157") ; <CJK>
       (?$(LMn(B . "0x83F7") ; <CJK>
       (?$(LNO(B . "0x8849") ; <CJK>
       (?$(LN`(B . "0x8999") ; <CJK>
       (?$(LOo(B . "0x921F") ; <CJK>
       (?$(LPt(B . "0x5313") ; <CJK>
       (?$(LQ6(B . "0x5606") ; <CJK>
       (?$(LQC(B . "0x55E0") ; <CJK>
       (?$(LQ^(B . "0x5922") ; <CJK>
       (?$(LR@(B . "0x5ECA") ; <CJK>
       (?$(LRd(B . "0x6139") ; <CJK>
       (?$(LRf(B . "0x614E") ; <CJK>
       (?$(LS<(B . "0x6691") ; <CJK>
       (?$(LTD(B . "0x6E7F") ; <CJK>
       (?$(LTN(B . "0x6ED7") ; <CJK>
       (?$(LT|(B . "0x733D") ; <CJK>
       (?$(L[[(B . "0x5716") ; <CJK>
       (?$(L\/(B . "0x5900") ; <CJK>
       (?$(L]K(B . "0x6577") ; <CJK>
       (?$(L]h(B . "0x69A3") ; <CJK>
       (?$(L`X(B . "0x7FE4") ; <CJK>
       (?$(L``(B . "0x8088") ; <CJK>
       ))))

(provide 'u-cns-6)

;;; u-cns-6.el ends here
