/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;

class ptutils {
    public boolean success = false;
    public ptglobals gl;
    static final int _initProgress = 0;
    static final int _setProgress = 1;
    static final int _disposeProgress = 2;
    static final int _idleProgress = 3;
    static ptprogress pr = null;
    static ptinfodlg pi = null;
    int[] px_opt;
    int[] px_reg;
    int[] px_seek;
    int[] px_dest;
    int w_reg;
    int w_seek;
    static int[][] BicCoeff = null;

    public ptutils(ptglobals ptglobals2) {
        this.gl = ptglobals2;
        try {
            System.loadLibrary("pano12.lib");
            this.success = true;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("pano12");
            this.success = true;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public Image ptLoadImage(int n) {
        this.CLoadImage(n);
        int n2 = this.CGetImageWidth(n);
        int n3 = this.CGetImageHeight(n);
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n3) {
            this.CGetImageRow(nArray2, n4);
            System.arraycopy(nArray2, 0, nArray, n4 * n2, n2);
            ++n4;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
    }

    public String getImageName(int n) {
        String string = this.CGetImageName(n);
        if (string.equals("")) {
            return "Image" + n;
        }
        return string;
    }

    public void setImageName(String string, int n) {
        this.CSetImageName(n, string);
    }

    public int getIndex(String string) {
        return this.CGetIndex(string);
    }

    public void loadProject(String string, ptproject ptproject2) {
        Object object;
        this.CLoadProject(string);
        ptproject2.numIm = this.CGetImageCount();
        if (ptproject2.numIm == 0) {
            return;
        }
        ptproject2.nc = this.CGetControlPointCount();
        int n = 0;
        while (n < ptproject2.nc) {
            object = new controlPoint(this.CGetCP_n(n, 0), this.CGetCP_n(n, 1), this.CGetCP_x(n, 0), this.CGetCP_x(n, 1), this.CGetCP_y(n, 0), this.CGetCP_y(n, 1), this.CGetCP_t(n));
            ptproject2.cp.put(new Integer(n), object);
            ++n;
        }
        ptproject2.nt = this.CGetTriangleCount();
        n = 0;
        while (n < ptproject2.nt) {
            object = new triangle(this.CGetTR_v(n, 0), this.CGetTR_v(n, 1), this.CGetTR_v(n, 2), this.CGetTR_i(n));
            ptproject2.tr.put(new Integer(n), object);
            ++n;
        }
    }

    public void saveProject(String string, ptproject ptproject2) {
        Object object;
        this.CSetControlPointCount(ptproject2.nc);
        int n = 0;
        while (n < ptproject2.nc) {
            object = (controlPoint)ptproject2.cp.get(new Integer(n));
            this.CSetCP(n, ((controlPoint)object).n[0], ((controlPoint)object).n[1], ((controlPoint)object).x[0], ((controlPoint)object).x[1], ((controlPoint)object).y[0], ((controlPoint)object).y[1], ((controlPoint)object).type);
            ++n;
        }
        this.CSetTriangleCount(ptproject2.nt);
        n = 0;
        while (n < ptproject2.nt) {
            object = (triangle)ptproject2.tr.get(new Integer(n));
            this.CSetTR(n, ((triangle)object).vert[0], ((triangle)object).vert[1], ((triangle)object).vert[2], ((triangle)object).nIm);
            ++n;
        }
        if (string == null) {
            this.CSaveProject("");
        } else {
            this.CSaveProject(string);
        }
    }

    public void triangulate(int n, ptproject ptproject2) {
        triangle triangle2;
        ptproject2.compact();
        this.CSetTriangleCount(ptproject2.nt);
        int n2 = 0;
        while (n2 < ptproject2.nt) {
            triangle2 = (triangle)ptproject2.tr.get(new Integer(n2));
            this.CSetTR(n2, triangle2.vert[0], triangle2.vert[1], triangle2.vert[2], triangle2.nIm);
            ++n2;
        }
        this.CTriangulate(n);
        ptproject2.tr = new Hashtable();
        ptproject2.nt = this.CGetTriangleCount();
        n2 = 0;
        while (n2 < ptproject2.nt) {
            triangle2 = new triangle(this.CGetTR_v(n2, 0), this.CGetTR_v(n2, 1), this.CGetTR_v(n2, 2), this.CGetTR_i(n2));
            ptproject2.tr.put(new Integer(n2), triangle2);
            ++n2;
        }
    }

    public void reduce(int n, ptproject ptproject2) {
        triangle triangle2;
        ptproject2.compact();
        this.CSetTriangleCount(ptproject2.nt);
        int n2 = 0;
        while (n2 < ptproject2.nt) {
            triangle2 = (triangle)ptproject2.tr.get(new Integer(n2));
            this.CSetTR(n2, triangle2.vert[0], triangle2.vert[1], triangle2.vert[2], triangle2.nIm);
            ++n2;
        }
        this.CReduce(n);
        ptproject2.tr = new Hashtable();
        ptproject2.nt = this.CGetTriangleCount();
        n2 = 0;
        while (n2 < ptproject2.nt) {
            triangle2 = new triangle(this.CGetTR_v(n2, 0), this.CGetTR_v(n2, 1), this.CGetTR_v(n2, 2), this.CGetTR_i(n2));
            ptproject2.tr.put(new Integer(n2), triangle2);
            ++n2;
        }
    }

    public void PrintError(String string) {
        if (this.gl.picker != null) {
            ptalert ptalert2 = new ptalert((Frame)this.gl.picker, string);
            ((Component)ptalert2).setVisible(true);
        }
    }

    public void createProject(String string) {
        int n = 4;
        int n2 = 0;
        String string2 = this.gl.properties.getProperty("PanoramaMapping");
        if (string2.equals("equirectangular")) {
            n = 4;
        } else if (string2.equals("cylindrical")) {
            n = 1;
        } else if (string2.equals("cubic")) {
            n = 9;
        }
        string2 = this.gl.properties.getProperty("ImageMapping");
        if (string2.equals("rectilinear")) {
            n2 = 0;
        } else if (string2.equals("fisheye")) {
            n2 = 3;
        }
        string2 = this.gl.properties.getProperty("PanoramaFileFormat");
        if (string2.equals("Photoshop")) {
            string2 = "PSD_mask";
        }
        this.CCreateProject(string, n, string2, n2, Integer.parseInt(this.gl.properties.getProperty("ImageCount")), Double.valueOf(this.gl.properties.getProperty("ImageFocalLength")));
    }

    public int Progress(int n, String string) {
        if (this.gl.picker == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                pr = new ptprogress((Frame)this.gl.picker, string);
                ((Component)pr).setVisible(true);
                return 1;
            }
            case 1: {
                if (pr == null) {
                    return 1;
                }
                ptutils.pr.progress = Integer.parseInt(string);
                if (ptutils.pr.stop) {
                    pr = null;
                    return 0;
                }
                pr.repaint();
                return 1;
            }
            case 2: {
                if (pr == null) {
                    return 1;
                }
                ((Component)pr).setVisible(false);
                pr = null;
                return 1;
            }
            case 3: {
                if (ptutils.pr.stop) {
                    pr = null;
                    return 0;
                }
                return 1;
            }
        }
        return 1;
    }

    public synchronized int infoDlg(int n, String string) {
        String string2 = null;
        if (this.gl.picker == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                if (pi == null) {
                    pi = new ptinfodlg((Frame)this.gl.picker, string);
                    ((Component)pi).setVisible(true);
                }
                return 1;
            }
            case 1: {
                if (pi == null) {
                    return 1;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string.startsWith("+")) {
                    ptutils.pi.text.setText(string2 + string.substring(1));
                } else {
                    string2 = new String(string);
                    ptutils.pi.text.setText(string2);
                }
                ptutils.pi.text.repaint();
                if (ptutils.pi.stop) {
                    pi = null;
                    return 0;
                }
                return 1;
            }
            case 2: {
                if (pi == null) {
                    return 1;
                }
                ((Component)pi).setVisible(false);
                pi = null;
                return 1;
            }
            case 3: {
                if (pi == null) {
                    return 1;
                }
                if (ptutils.pi.stop) {
                    pi = null;
                    return 0;
                }
                return 1;
            }
        }
        return 1;
    }

    double[] alignPoint(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            System.out.println("No data for optimizer");
            return null;
        }
        System.out.println("Start");
        double[] dArray = new double[2];
        this.px_reg = nArray;
        this.w_reg = (int)(Math.sqrt(this.px_reg.length) + 0.5);
        this.px_seek = nArray2;
        this.w_seek = (int)(Math.sqrt(this.px_seek.length) + 0.5);
        this.px_dest = new int[this.px_reg.length];
        this.px_opt = new int[6];
        this.px_opt[0] = 0;
        this.px_opt[1] = 8192;
        this.px_opt[2] = 0;
        this.px_opt[3] = 0;
        this.bracket();
        dArray[0] = -((double)this.px_opt[2]) / 256.0;
        dArray[1] = -((double)this.px_opt[3]) / 256.0;
        this.px_opt = null;
        this.px_dest = null;
        this.px_reg = null;
        this.px_seek = null;
        System.out.println("x = " + dArray[0] + "     y = " + dArray[1]);
        return dArray;
    }

    int[] smooth(int[] nArray) {
        int n = (int)(Math.sqrt(nArray.length) + 0.5);
        int[] nArray2 = new int[nArray.length];
        int n2 = n - 1;
        int n3 = 116;
        int n4 = 23;
        int n5 = 12;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n) {
            int n8 = 0;
            int n9 = n7;
            while (n8 < n) {
                if (n8 == 0 || n6 == 0 || n8 == n2 || n6 == n2) {
                    nArray2[n9] = nArray[n9];
                } else {
                    int n10;
                    int n11;
                    int n12 = nArray[n9];
                    int n13 = nArray[n9 - n];
                    int n14 = nArray[n9 - 1];
                    int n15 = nArray[n9 + 1];
                    int n16 = nArray[n9 + n];
                    int n17 = nArray[n9 - n - 1];
                    int n18 = nArray[n9 - n + 1];
                    int n19 = nArray[n9 + n - 1];
                    int n20 = nArray[n9 + n + 1];
                    int n21 = n3 * (n12 >> 16 & 0xFF) + n4 * ((n13 >> 16 & 0xFF) + (n14 >> 16 & 0xFF) + (n15 >> 16 & 0xFF) + (n16 >> 16 & 0xFF)) + n5 * ((n17 >> 16 & 0xFF) + (n18 >> 16 & 0xFF) + (n19 >> 16 & 0xFF) + (n20 >> 16 & 0xFF)) >> 8;
                    if (n21 > 255) {
                        n21 = 255;
                    }
                    if ((n11 = n3 * (n12 >> 8 & 0xFF) + n4 * ((n13 >> 8 & 0xFF) + (n14 >> 8 & 0xFF) + (n15 >> 8 & 0xFF) + (n16 >> 8 & 0xFF)) + n5 * ((n17 >> 8 & 0xFF) + (n18 >> 8 & 0xFF) + (n19 >> 8 & 0xFF) + (n20 >> 8 & 0xFF)) >> 8) > 255) {
                        n11 = 255;
                    }
                    if ((n10 = n3 * (n12 & 0xFF) + n4 * ((n13 & 0xFF) + (n14 & 0xFF) + (n15 & 0xFF) + (n16 & 0xFF)) + n5 * ((n17 & 0xFF) + (n18 & 0xFF) + (n19 & 0xFF) + (n20 & 0xFF)) >> 8) > 255) {
                        n10 = 255;
                    }
                    nArray2[n9] = (n12 & 0xFF000000) + (n21 << 16) + (n11 << 8) + n10;
                }
                ++n8;
                ++n9;
            }
            ++n6;
            n7 += n;
        }
        return nArray2;
    }

    void bracket() {
        int n = 4;
        long l = this.getFit();
        int n2 = 256;
        while (n2 >= 1) {
            boolean bl = true;
            while (bl) {
                bl = false;
                int n3 = 0;
                while (n3 < n) {
                    long l2;
                    boolean bl2 = false;
                    int n4 = n3;
                    this.px_opt[n4] = this.px_opt[n4] + n2;
                    if (n2 == 256) {
                        while ((l2 = this.getFit()) < l) {
                            bl2 = true;
                            l = l2;
                            int n5 = n3;
                            this.px_opt[n5] = this.px_opt[n5] + n2;
                        }
                        int n6 = n3;
                        this.px_opt[n6] = this.px_opt[n6] - n2;
                    } else {
                        l2 = this.getFit();
                        if (l2 < l) {
                            l = l2;
                            bl2 = true;
                        } else {
                            int n7 = n3;
                            this.px_opt[n7] = this.px_opt[n7] - n2;
                        }
                    }
                    if (!bl2) {
                        int n8 = n3;
                        this.px_opt[n8] = this.px_opt[n8] - n2;
                        if (n2 == 256) {
                            while ((l2 = this.getFit()) < l) {
                                bl2 = true;
                                l = l2;
                                int n9 = n3;
                                this.px_opt[n9] = this.px_opt[n9] - n2;
                            }
                            int n10 = n3;
                            this.px_opt[n10] = this.px_opt[n10] + n2;
                        } else {
                            l2 = this.getFit();
                            if (l2 < l) {
                                l = l2;
                                bl2 = true;
                            } else {
                                int n11 = n3;
                                this.px_opt[n11] = this.px_opt[n11] + n2;
                            }
                        }
                    }
                    if (bl2) {
                        bl = true;
                    }
                    ++n3;
                }
            }
            n2 /= 2;
        }
        System.out.println("Average error: " + Math.sqrt(l / (long)(3 * this.px_reg.length)));
    }

    long getFit() {
        this.px_transFormImage();
        long l = 0L;
        int n = 0;
        while (n < this.px_reg.length) {
            int n2 = this.px_reg[n];
            int n3 = this.px_dest[n];
            if ((n2 & 0xFF000000) != 0 && (n3 & 0xFF000000) != 0) {
                int n4 = (n2 >> 16 & 0xFF) - (n3 >> 16 & 0xFF);
                int n5 = (n2 >> 8 & 0xFF) - (n3 >> 8 & 0xFF);
                int n6 = (n2 & 0xFF) - (n3 & 0xFF);
                l += (long)(n4 * n4 + n5 * n5 + n6 * n6);
            } else {
                l += 195075L;
            }
            ++n;
        }
        return l;
    }

    void px_transFormImage() {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        double d = (double)this.px_opt[0] / 256.0 * Math.PI / 180.0;
        this.px_opt[4] = (int)(Math.cos(d) * 2048.0);
        this.px_opt[5] = (int)(Math.sin(d) * 2048.0);
        int n = this.w_reg * 128 - 128;
        int n2 = this.w_seek * 128 - 128;
        int n3 = this.w_seek - 1;
        int n4 = this.w_seek - 2;
        int n5 = 0;
        int n6 = 0;
        nArray2[1] = -n;
        while (n5 < this.w_reg) {
            int n7 = 0;
            int n8 = n6;
            nArray2[0] = -n;
            while (n7 < this.w_reg) {
                this.shift_scale_rotate(nArray, nArray2);
                nArray[0] = nArray[0] + n2;
                nArray[1] = nArray[1] + n2;
                int n9 = nArray[0] & 0xFF;
                nArray[0] = nArray[0] >> 8;
                int n10 = nArray[1] & 0xFF;
                nArray[1] = nArray[1] >> 8;
                if (nArray[0] > 0 && nArray[0] < n4 && nArray[1] > 0 && nArray[1] < n4) {
                    this.px_dest[n8] = this.bicubic(this.px_seek, nArray[1] * this.w_seek + nArray[0], this.w_seek, n9, n10);
                } else if (nArray[0] >= 0 && nArray[0] < n3 && nArray[1] >= 0 && nArray[1] < n3) {
                    int n11 = nArray[1] * this.w_seek + nArray[0];
                    this.px_dest[n8] = this.bil(this.px_seek[n11], this.px_seek[n11 + 1], this.px_seek[n11 + this.w_seek], this.px_seek[n11 + this.w_seek + 1], n9, n10);
                } else {
                    this.px_dest[n8] = 0;
                }
                ++n7;
                ++n8;
                nArray2[0] = nArray2[0] + 256;
            }
            ++n5;
            n6 += this.w_reg;
            nArray2[1] = nArray2[1] + 256;
        }
    }

    final void shift_scale_rotate(int[] nArray, int[] nArray2) {
        long l = nArray2[0];
        long l2 = nArray2[1];
        nArray[0] = (int)((l * (long)this.px_opt[4] - l2 * (long)this.px_opt[5]) * (long)this.px_opt[1] / 0x800000L) - this.px_opt[2];
        nArray[1] = (int)((l * (long)this.px_opt[5] + l2 * (long)this.px_opt[4]) * (long)this.px_opt[1] / 0x800000L) - this.px_opt[3];
    }

    final int bil(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 & 0xFF;
        int n8 = 255 - n5 & 0xFF;
        int n9 = n8 * (n >> 16 & 0xFF) + n7 * (n2 >> 16 & 0xFF);
        int n10 = n8 * (n >> 8 & 0xFF) + n7 * (n2 >> 8 & 0xFF);
        int n11 = n8 * (n & 0xFF) + n7 * (n2 & 0xFF);
        int n12 = n8 * (n3 >> 16 & 0xFF) + n7 * (n4 >> 16 & 0xFF);
        int n13 = n8 * (n3 >> 8 & 0xFF) + n7 * (n4 >> 8 & 0xFF);
        int n14 = n8 * (n3 & 0xFF) + n7 * (n4 & 0xFF);
        int n15 = 255 - n6;
        n9 = n9 * n15 + n12 * n6 >> 16;
        n10 = n10 * n15 + n13 * n6 >> 16;
        n11 = n11 * n15 + n14 * n6 >> 16;
        return (n9 << 16) + (n10 << 8) + n11 + -16777216;
    }

    final int bicubic(int[] nArray, int n, int n2, int n3, int n4) {
        int[] nArray2 = this.pt_getBicubicCoefficients(n3);
        int[] nArray3 = this.pt_getBicubicCoefficients(n4);
        int n5 = n - n2 - 1;
        int n6 = nArray[n] & 0xFF000000;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n7 < 4) {
            int n11 = 0;
            int n12 = 0;
            while (n11 < 4) {
                n12 += (nArray[n5 + n11] >> 16 & 0xFF) * nArray2[n11];
                ++n11;
            }
            n8 += n12 * nArray3[n7];
            n11 = 0;
            n12 = 0;
            while (n11 < 4) {
                n12 += (nArray[n5 + n11] >> 8 & 0xFF) * nArray2[n11];
                ++n11;
            }
            n9 += n12 * nArray3[n7];
            n11 = 0;
            n12 = 0;
            while (n11 < 4) {
                n12 += (nArray[n5 + n11] & 0xFF) * nArray2[n11];
                ++n11;
            }
            n10 += n12 * nArray3[n7];
            ++n7;
            n5 += n2;
        }
        if ((n8 >>= 16) > 255) {
            n8 = 255;
        }
        if ((n9 >>= 16) > 255) {
            n9 = 255;
        }
        if ((n10 >>= 16) > 255) {
            n10 = 255;
        }
        return n6 + (n8 << 16) + (n9 << 8) + n10;
    }

    int[] pt_getBicubicCoefficients(int n) {
        if (BicCoeff == null) {
            this.SetupBicCoeff();
        }
        return BicCoeff[n];
    }

    void SetupBicCoeff() {
        BicCoeff = new int[256][4];
        double d = -0.75;
        int n = 0;
        while (n < 256) {
            double d2 = (double)n / 256.0 + 1.0;
            ptutils.BicCoeff[n][0] = (int)(256.0 * (((d * d2 - 5.0 * d) * d2 + 8.0 * d) * d2 - 4.0 * d));
            d2 = (double)n / 256.0;
            ptutils.BicCoeff[n][1] = (int)(256.0 * (((d + 2.0) * d2 - (d + 3.0)) * d2 * d2 + 1.0));
            d2 = 1.0 - (double)n / 256.0;
            ptutils.BicCoeff[n][2] = (int)(256.0 * (((d + 2.0) * d2 - (d + 3.0)) * d2 * d2 + 1.0));
            d2 = 2.0 - (double)n / 256.0;
            ptutils.BicCoeff[n][3] = (int)(256.0 * (((d * d2 - 5.0 * d) * d2 + 8.0 * d) * d2 - 4.0 * d));
            ++n;
        }
    }

    int[] shiftpix(double d, double d2, int[] nArray) {
        int n;
        int n2 = (int)(Math.sqrt(nArray.length) - 0.5);
        int n3 = n2 - 1;
        int[] nArray2 = null;
        try {
            nArray2 = new int[n2 * n2];
        }
        catch (Exception exception) {
            return null;
        }
        int n4 = (int)(d * 255.0);
        if (n4 > 255) {
            n4 = 255;
        }
        if ((n = (int)(d2 * 255.0)) > 255) {
            n = 255;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            int n7 = n5 * n2;
            int n8 = n5 * (n2 + 1);
            while (n6 < n2) {
                nArray2[n7] = n6 > 0 && n5 > 0 && n6 < n3 && n5 < n3 ? this.bicubic(nArray, n8, n2 + 1, n4, n) : this.bil(nArray[n8], nArray[n8 + 1], nArray[n8 + n2], nArray[n8 + n2 + 1], n4, n);
                ++n6;
                ++n7;
                ++n8;
            }
            ++n5;
        }
        return nArray2;
    }

    public native void CAlignPoint(double[] var1, int[] var2, int[] var3);

    public native void CSaveProject(String var1);

    public native void CSetControlPointCount(int var1);

    public native void CSetCP(int var1, int var2, int var3, double var4, double var6, double var8, double var10, int var12);

    public native void CSetTriangleCount(int var1);

    public native void CSetTR(int var1, int var2, int var3, int var4, int var5);

    public native void CLoadProject(String var1);

    public native int CGetImageCount();

    public native String CGetImageName(int var1);

    public native int CGetControlPointCount();

    public native int CGetCP_n(int var1, int var2);

    public native double CGetCP_x(int var1, int var2);

    public native double CGetCP_y(int var1, int var2);

    public native int CGetCP_t(int var1);

    public native int CGetTriangleCount();

    public native int CGetTR_v(int var1, int var2);

    public native int CGetTR_i(int var1);

    public native void CSetImageName(int var1, String var2);

    public native int CGetIndex(String var1);

    public native void CLoadImage(int var1);

    public native void CGetImageRow(int[] var1, int var2);

    public native int CGetImageWidth(int var1);

    public native int CGetImageHeight(int var1);

    public native void CCreateProject(String var1, int var2, String var3, int var4, int var5, double var6);

    public native void CTriangulate(int var1);

    public native void CReduce(int var1);

    public native void CCallOptimizer();

    public native void CShowScript();

    public native void CLaunchAndSendScript(String var1, String var2);

    public native int CGetImageFormat(int var1);

    public native double CGetHfov(int var1);

    public native double CGetYaw(int var1);

    public native double CGetPitch(int var1);

    public native double CGetRoll(int var1);
}

