% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{as_white_ref}
\alias{as_white_ref}
\title{Convert value to a tristimulus values normalised to Y=100}
\usage{
as_white_ref(x, fow = 2)
}
\arguments{
\item{x}{A string giving the name of the standardized illuminant or a
2 (chromaticity) or 3 (trsitimulus) length numeric vector.}

\item{fow}{The field-of-view for the illuminant - either \code{2} or \code{10}}
}
\value{
A 3-length vector with tristimulus values
}
\description{
This function can take either the name of a standardised illuminants, x
and y chromaticity coordinates or X, Y, and Z tristimulus values and converts
it to tristimulus values normalised to Y=100. All Illuminant series A-F are
supported and can be queried both on the CIE 1931 2° and CIE 1964 10°
chromaticity coordinates.
}
\examples{
# Using names
as_white_ref('D65')

# Using chromaticity values
as_white_ref(c(0.3, 0.4))
}
\keyword{internal}
