% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{system_r_platform}
\alias{system_r_platform}
\alias{system_r_platform_data}
\title{R platforms}
\usage{
system_r_platform()

system_r_platform_data()
}
\value{
\code{system_r_platform()} returns a character scalar.

\code{system_r_platform_data()} returns a data frame with character
scalar columns:
\itemize{
\item \code{cpu},
\item \code{vendor},
\item \code{os},
\item \code{distribution} (only on Linux),
\item \code{release} (only on Linux),
\item \code{platform}: the concatenation of the other columns, separated by
a dash.
}
}
\description{
R platforms
}
\details{
\code{system_r_platform()} detects the platform of the current R version.
\code{system_r_platform_data()} is similar, but returns the raw data instead
of a character scalar.

By default pak works with source packages and binary packages for
the current platform. You can change this, by providing different
platform names in the \code{\link[=pak-config]{pkg.platforms}} option or the
\code{\link[=pak-config]{PKG_PLATFORMS}} environment variable.

This option may contain the following platform names:
\itemize{
\item \code{"source"} for source packages,
\item \code{"macos"} for macOS binaries that are appropriate for the R versions
pak is working with. Packages for incompatible CPU architectures are
dropped (defaulting to the CPU of the current macOS machine and x86_64 on
non-macOS systems). The macOS Darwin version is selected based on the
CRAN macOS binaries. E.g. on R 3.5.0 macOS binaries
are built for macOS El Capitan.
\item \code{"windows"} for Windows binaries for the default CRAN architecture.
This is currently Windows Vista for all supported R versions, but it
might change in the future. The actual binary packages in the
repository might support both 32 bit and 64 builds, or only one of
them. In practice 32-bit only packages are very rare. CRAN builds
before and including R 4.1 have both architectures, from R 4.2 they
are 64 bit only. \code{"windows"} is an alias to \code{i386+x86_64-w64-mingw32}
currently.
\item A platform string like \code{R.version$platform}, but on Linux the name
and version of the distribution are also included. Examples:
\itemize{
\item \code{x86_64-apple-darwin17.0}: macOS High Sierra.
\item \code{aarch64-apple-darwin20}: macOS Big Sur on arm64.
\item \code{x86_64-w64-mingw32}: 64 bit Windows.
\item \code{i386-w64-mingw32}: 32 bit Windows.
\item \code{i386+x86_64-w64-mingw32}: 64 bit + 32 bit Windows.
\item \code{i386-pc-solaris2.10}: 32 bit Solaris. (Some broken 64 Solaris
builds might have the same platform string, unfortunately.)
\item \code{x86_64-pc-linux-gnu-debian-10}: Debian Linux 10 on x86_64.
\item \verb{x86_64-pc-linux-musl-alpine-3.14.1}: Alpine Linux.
\item \code{x86_64-pc-linux-gnu-unknown}: Unknown Linux Distribution on x86_64.
\item \code{s390x-ibm-linux-gnu-ubuntu-20.04}: Ubuntu Linux 20.04 on S390x.
\item \code{amd64-portbld-freebsd12.1}: FreeBSD 12.1 on x86_64.
}
}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
system_r_platform()
system_r_platform_data()
\dontshow{\}) # examplesIf}
}
\seealso{
These function call \code{\link[pkgcache:current_r_platform]{pkgcache::current_r_platform()}} and
\code{\link[pkgcache:current_r_platform]{pkgcache::current_r_platform_data()}}.
}
