% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url_check.R
\name{url_check}
\alias{url_check}
\title{Check urls in a package}
\usage{
url_check(
  path = ".",
  db = NULL,
  parallel = TRUE,
  pool = curl::new_pool(),
  progress = TRUE
)
}
\arguments{
\item{path}{Path to the package}

\item{db}{A url database}

\item{parallel}{If \code{TRUE}, check the URLs in parallel}

\item{pool}{A multi handle created by \code{\link[curl:multi]{curl::new_pool()}}. If \code{NULL} use a global pool.}

\item{progress}{Whether to show the progress bar for parallel checks}
}
\value{
A \code{url_checker_db} object (invisibly). This is a \code{check_url_db} object
with an added class with a custom print method.
}
\description{
Runs the \code{url_db_from_package_source} function in the tools package along
with a function to check URLs in un-rendered Rmarkdown vignettes.
}
\examples{
\dontrun{
url_check("my_pkg")
}
}
