package ONVIF::Media::Types::AnalyticsEngineControl;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Media::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %EngineToken_of :ATTR(:get<EngineToken>);
my %EngineConfigToken_of :ATTR(:get<EngineConfigToken>);
my %InputToken_of :ATTR(:get<InputToken>);
my %ReceiverToken_of :ATTR(:get<ReceiverToken>);
my %Multicast_of :ATTR(:get<Multicast>);
my %Subscription_of :ATTR(:get<Subscription>);
my %Mode_of :ATTR(:get<Mode>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        EngineToken
        EngineConfigToken
        InputToken
        ReceiverToken
        Multicast
        Subscription
        Mode

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'EngineToken' => \%EngineToken_of,
        'EngineConfigToken' => \%EngineConfigToken_of,
        'InputToken' => \%InputToken_of,
        'ReceiverToken' => \%ReceiverToken_of,
        'Multicast' => \%Multicast_of,
        'Subscription' => \%Subscription_of,
        'Mode' => \%Mode_of,
    },
    {
        'Name' => 'ONVIF::Media::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'EngineToken' => 'ONVIF::Media::Types::ReferenceToken',
        'EngineConfigToken' => 'ONVIF::Media::Types::ReferenceToken',
        'InputToken' => 'ONVIF::Media::Types::ReferenceToken',
        'ReceiverToken' => 'ONVIF::Media::Types::ReferenceToken',
        'Multicast' => 'ONVIF::Media::Types::MulticastConfiguration',
        'Subscription' => 'ONVIF::Media::Types::Config',
        'Mode' => 'ONVIF::Media::Types::ModeOfOperation',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'EngineToken' => 'EngineToken',
        'EngineConfigToken' => 'EngineConfigToken',
        'InputToken' => 'InputToken',
        'ReceiverToken' => 'ReceiverToken',
        'Multicast' => 'Multicast',
        'Subscription' => 'Subscription',
        'Mode' => 'Mode',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::AnalyticsEngineControl

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsEngineControl from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EngineToken


=item * EngineConfigToken


=item * InputToken


=item * ReceiverToken


=item * Multicast


=item * Subscription


=item * Mode




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::AnalyticsEngineControl
   EngineToken => $some_value, # ReferenceToken
   EngineConfigToken => $some_value, # ReferenceToken
   InputToken => $some_value, # ReferenceToken
   ReceiverToken => $some_value, # ReferenceToken
   Multicast =>  { # ONVIF::Media::Types::MulticastConfiguration
     Address =>  { # ONVIF::Media::Types::IPAddress
       Type => $some_value, # IPType
       IPv4Address => $some_value, # IPv4Address
       IPv6Address => $some_value, # IPv6Address
     },
     Port =>  $some_value, # int
     TTL =>  $some_value, # int
     AutoStart =>  $some_value, # boolean
   },
   Subscription =>  { # ONVIF::Media::Types::Config
     Parameters =>  { # ONVIF::Media::Types::ItemList
       SimpleItem => ,
       ElementItem =>  {
       },
       Extension =>  { # ONVIF::Media::Types::ItemListExtension
       },
     },
   },
   Mode => $some_value, # ModeOfOperation
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

