/* $Id: wordfuncs.c,v 1.2 1996/09/12 14:20:56 fraser Exp $
   $Log: wordfuncs.c,v $
   Revision 1.2  1996/09/12 14:20:56  fraser
   add module version printing

 * Revision 1.1  1996/09/12  13:20:18  fraser
 * Initial revision
 *
*/
/* wordfuncs.c: word manipulating functions for agm
*/

char wordfuncs_RCSid[] = "$Revision: 1.2 $";

#include "agm.h"

int contains (word, subword, length)
    char *word, *subword;
    unsigned int *length;
{
  char copyword[WORDLEN];
  char *cpos, *sloop;

  strcpy (copyword, word);
  sloop = subword;
  while (*sloop != '\0') {
    if ((cpos = strchr (copyword, *sloop++)) == NULL) {
      /* a character is found which is not in word, so return FALSE */
      return FALSE;
    }
    else { /* else remove it */
      *cpos = HIDECHAR;
    }
  }
  *length = sloop - subword;
  return TRUE;
}

int eliminate (word, subword, remains)
    char *word, *subword, *remains;
{
  char copyword[WORDLEN];
  char *remloop = remains, *copyloop = copyword;

  strcpy (copyword, word);
  while (*subword != '\0') {
    *(strchr (copyword, *subword++)) = HIDECHAR;
  }
  while (*copyloop != '\0') {
    if (*copyloop != HIDECHAR) {
      *remloop++ = *copyloop;
    }
    ++copyloop;
  }
  *remloop = '\0';
}

minus_process (word, command)
    char *word, *command;
{
  char *minus_pos, copy[WORDLEN];
  unsigned int dummy;

  if ((minus_pos = strchr (word, MINUS)) == NULL) {
    return; /* no minus, so don't bother */
  }
  else {
    *minus_pos++ = '\0';
    if (!contains (word, minus_pos, &dummy)) {
      fprintf (stderr, "\"%s\" does not contain \"%s\"\n",
	       word, minus_pos);
      exit (-1);
    }
    if (notquiet) printf ("%s: removing \"%s\" from \"%s\"", command, minus_pos, word);
    eliminate (word, minus_pos, copy);
    if (notquiet) printf (" to give \"%s\"\n", copy);
    strcpy (word, copy);
  }
}

void copysmall (s1, s2)
  char
      *s1, *s2;
{
  while (*s2 != '\0') {
    if (*s2 >= 'A' && *s2 <= 'Z') {
      (*s1++) = (*s2++) + ('a' - 'A');
    }
    else {
      *s1++ = *s2++;
    }
  }
  *s1 = '\0';
}
