// GENERATED FILE - DO NOT EDIT.
// Generated by gen_texture_format_table.py using data from texture_format_data.json
//
// Copyright 2016 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// texture_format_table:
//   Queries for full textureFormat information based in internalFormat
//

#include "libANGLE/renderer/d3d/d3d11/texture_format_table.h"

#include "libANGLE/renderer/copyimage.h"
#include "libANGLE/renderer/d3d/d3d11/formatutils11.h"
#include "libANGLE/renderer/d3d/d3d11/load_functions_table.h"
#include "libANGLE/renderer/d3d/d3d11/renderer11_utils.h"
#include "libANGLE/renderer/d3d/generatemip.h"
#include "libANGLE/renderer/d3d/loadimage.h"

namespace rx
{

namespace d3d11
{

namespace
{

typedef bool (*FormatSupportFunction)(const Renderer11DeviceCaps &);

bool OnlyFL10Plus(const Renderer11DeviceCaps &deviceCaps)
{
    return (deviceCaps.featureLevel >= D3D_FEATURE_LEVEL_10_0);
}

bool OnlyFL9_3(const Renderer11DeviceCaps &deviceCaps)
{
    return (deviceCaps.featureLevel == D3D_FEATURE_LEVEL_9_3);
}

template <DXGI_FORMAT format, bool requireSupport>
bool SupportsFormat(const Renderer11DeviceCaps &deviceCaps)
{
    // Must support texture, SRV and RTV support
    UINT mustSupport = D3D11_FORMAT_SUPPORT_TEXTURE2D | D3D11_FORMAT_SUPPORT_TEXTURECUBE |
                       D3D11_FORMAT_SUPPORT_SHADER_SAMPLE | D3D11_FORMAT_SUPPORT_MIP |
                       D3D11_FORMAT_SUPPORT_RENDER_TARGET;

    if (d3d11_gl::GetMaximumClientVersion(deviceCaps.featureLevel) > 2)
    {
        mustSupport |= D3D11_FORMAT_SUPPORT_TEXTURE3D;
    }

    bool fullSupport = false;
    if (format == DXGI_FORMAT_B5G6R5_UNORM)
    {
        // All hardware that supports DXGI_FORMAT_B5G6R5_UNORM should support autogen mipmaps, but
        // check anyway.
        mustSupport |= D3D11_FORMAT_SUPPORT_MIP_AUTOGEN;
        fullSupport = ((deviceCaps.B5G6R5support & mustSupport) == mustSupport);
    }
    else if (format == DXGI_FORMAT_B4G4R4A4_UNORM)
    {
        fullSupport = ((deviceCaps.B4G4R4A4support & mustSupport) == mustSupport);
    }
    else if (format == DXGI_FORMAT_B5G5R5A1_UNORM)
    {
        fullSupport = ((deviceCaps.B5G5R5A1support & mustSupport) == mustSupport);
    }
    else
    {
        UNREACHABLE();
        return false;
    }

    // This 'SupportsFormat' function is used by individual entries in the D3D11 Format Map below,
    // which maps GL formats to DXGI formats.
    if (requireSupport)
    {
        // This means that ANGLE would like to use the entry in the map if the inputted DXGI format
        // *IS* supported.
        // e.g. the entry might map GL_RGB5_A1 to DXGI_FORMAT_B5G5R5A1, which should only be used if
        // DXGI_FORMAT_B5G5R5A1 is supported.
        // In this case, we should only return 'true' if the format *IS* supported.
        return fullSupport;
    }
    else
    {
        // This means that ANGLE would like to use the entry in the map if the inputted DXGI format
        // *ISN'T* supported.
        // This might be a fallback entry. e.g. for ANGLE to use DXGI_FORMAT_R8G8B8A8_UNORM if
        // DXGI_FORMAT_B5G5R5A1 isn't supported.
        // In this case, we should only return 'true' if the format *ISN'T* supported.
        return !fullSupport;
    }
}

// End Format Support Functions
}  // namespace

ANGLEFormatSet::ANGLEFormatSet()
    : format(ANGLE_FORMAT_NONE),
      glInternalFormat(GL_NONE),
      texFormat(DXGI_FORMAT_UNKNOWN),
      srvFormat(DXGI_FORMAT_UNKNOWN),
      rtvFormat(DXGI_FORMAT_UNKNOWN),
      dsvFormat(DXGI_FORMAT_UNKNOWN),
      blitSRVFormat(DXGI_FORMAT_UNKNOWN),
      swizzleFormat(ANGLE_FORMAT_NONE),
      mipGenerationFunction(nullptr),
      colorReadFunction(nullptr)
{
}

// For sized GL internal formats, there are several possible corresponding D3D11 formats depending
// on device capabilities.
// This function allows querying for the DXGI texture formats to use for textures, SRVs, RTVs and
// DSVs given a GL internal format.
TextureFormat::TextureFormat(GLenum internalFormat,
                             const ANGLEFormat angleFormat,
                             InitializeTextureDataFunction internalFormatInitializer)
    : dataInitializerFunction(internalFormatInitializer)
{
    formatSet        = &GetANGLEFormatSet(angleFormat);
    swizzleFormatSet = &GetANGLEFormatSet(formatSet->swizzleFormat);

    // Gather all the load functions for this internal format
    loadFunctions = GetLoadFunctionsMap(internalFormat, formatSet->texFormat);

    ASSERT(loadFunctions.size() != 0 || internalFormat == GL_NONE);
}

ANGLEFormatSet::ANGLEFormatSet(ANGLEFormat format,
                               GLenum glInternalFormat,
                               DXGI_FORMAT texFormat,
                               DXGI_FORMAT srvFormat,
                               DXGI_FORMAT rtvFormat,
                               DXGI_FORMAT dsvFormat,
                               DXGI_FORMAT blitSRVFormat,
                               ANGLEFormat swizzleFormat,
                               MipGenerationFunction mipGenerationFunction,
                               ColorReadFunction colorReadFunction)
    : format(format),
      glInternalFormat(glInternalFormat),
      texFormat(texFormat),
      srvFormat(srvFormat),
      rtvFormat(rtvFormat),
      dsvFormat(dsvFormat),
      blitSRVFormat(blitSRVFormat),
      swizzleFormat(swizzleFormat),
      mipGenerationFunction(mipGenerationFunction),
      colorReadFunction(colorReadFunction)
{
}

const ANGLEFormatSet &GetANGLEFormatSet(ANGLEFormat angleFormat)
{
    // clang-format off
    switch (angleFormat)
    {
        case ANGLE_FORMAT_A8_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_A8_UNORM,
                                                   GL_ALPHA8_EXT,
                                                   DXGI_FORMAT_A8_UNORM,
                                                   DXGI_FORMAT_A8_UNORM,
                                                   DXGI_FORMAT_A8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_A8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<A8>,
                                                   ReadColor<A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_B4G4R4A4_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_B4G4R4A4_UNORM,
                                                   GL_RGBA4,
                                                   DXGI_FORMAT_B4G4R4A4_UNORM,
                                                   DXGI_FORMAT_B4G4R4A4_UNORM,
                                                   DXGI_FORMAT_B4G4R4A4_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_B4G4R4A4_UNORM,
                                                   ANGLE_FORMAT_B4G4R4A4_UNORM,
                                                   GenerateMip<A4R4G4B4>,
                                                   ReadColor<A4R4G4B4, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_B5G5R5A1_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_B5G5R5A1_UNORM,
                                                   GL_RGB5_A1,
                                                   DXGI_FORMAT_B5G5R5A1_UNORM,
                                                   DXGI_FORMAT_B5G5R5A1_UNORM,
                                                   DXGI_FORMAT_B5G5R5A1_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_B5G5R5A1_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<A1R5G5B5>,
                                                   ReadColor<A1R5G5B5, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_B5G6R5_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_B5G6R5_UNORM,
                                                   GL_RGB565,
                                                   DXGI_FORMAT_B5G6R5_UNORM,
                                                   DXGI_FORMAT_B5G6R5_UNORM,
                                                   DXGI_FORMAT_B5G6R5_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_B5G6R5_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R5G6B5>,
                                                   ReadColor<R5G6B5, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_B8G8R8A8_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                   GL_BGRA8_EXT,
                                                   DXGI_FORMAT_B8G8R8A8_UNORM,
                                                   DXGI_FORMAT_B8G8R8A8_UNORM,
                                                   DXGI_FORMAT_B8G8R8A8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_B8G8R8A8_UNORM,
                                                   ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                   GenerateMip<B8G8R8A8>,
                                                   ReadColor<B8G8R8A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_BC1_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_BC1_UNORM,
                                                   GL_COMPRESSED_RGBA_S3TC_DXT1_EXT,
                                                   DXGI_FORMAT_BC1_UNORM,
                                                   DXGI_FORMAT_BC1_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_BC1_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_BC2_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_BC2_UNORM,
                                                   GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE,
                                                   DXGI_FORMAT_BC2_UNORM,
                                                   DXGI_FORMAT_BC2_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_BC2_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_BC3_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_BC3_UNORM,
                                                   GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE,
                                                   DXGI_FORMAT_BC3_UNORM,
                                                   DXGI_FORMAT_BC3_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_BC3_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D16_UNORM_FL10:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D16_UNORM_FL10,
                                                   GL_DEPTH_COMPONENT16,
                                                   DXGI_FORMAT_R16_TYPELESS,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D16_UNORM,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D16_UNORM_FL9_3:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D16_UNORM_FL9_3,
                                                   GL_DEPTH_COMPONENT16,
                                                   DXGI_FORMAT_D16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D24_UNORM_S8_UINT_FL10:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D24_UNORM_S8_UINT_FL10,
                                                   GL_DEPTH24_STENCIL8_OES,
                                                   DXGI_FORMAT_R24G8_TYPELESS,
                                                   DXGI_FORMAT_R24_UNORM_X8_TYPELESS,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                   DXGI_FORMAT_R24_UNORM_X8_TYPELESS,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D24_UNORM_S8_UINT_FL9_3:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D24_UNORM_S8_UINT_FL9_3,
                                                   GL_DEPTH24_STENCIL8_OES,
                                                   DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D32_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D32_FLOAT,
                                                   GL_DEPTH_COMPONENT32F,
                                                   DXGI_FORMAT_R32_TYPELESS,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D32_FLOAT,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_D32_FLOAT_S8X24_UINT_FL10:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_D32_FLOAT_S8X24_UINT_FL10,
                                                   GL_DEPTH32F_STENCIL8,
                                                   DXGI_FORMAT_R32G8X24_TYPELESS,
                                                   DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D32_FLOAT_S8X24_UINT,
                                                   DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_NONE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_NONE,
                                                   GL_NONE,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   ANGLE_FORMAT_NONE,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }
        case ANGLE_FORMAT_R10G10B10A2_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R10G10B10A2_UINT,
                                                   GL_RGB10_A2UI,
                                                   DXGI_FORMAT_R10G10B10A2_UINT,
                                                   DXGI_FORMAT_R10G10B10A2_UINT,
                                                   DXGI_FORMAT_R10G10B10A2_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R10G10B10A2_UINT,
                                                   ANGLE_FORMAT_R16G16B16A16_UINT,
                                                   GenerateMip<R10G10B10A2>,
                                                   ReadColor<R10G10B10A2, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R10G10B10A2_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R10G10B10A2_UNORM,
                                                   GL_RGB10_A2,
                                                   DXGI_FORMAT_R10G10B10A2_UNORM,
                                                   DXGI_FORMAT_R10G10B10A2_UNORM,
                                                   DXGI_FORMAT_R10G10B10A2_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R10G10B10A2_UNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   GenerateMip<R10G10B10A2>,
                                                   ReadColor<R10G10B10A2, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R11G11B10_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R11G11B10_FLOAT,
                                                   GL_R11F_G11F_B10F,
                                                   DXGI_FORMAT_R11G11B10_FLOAT,
                                                   DXGI_FORMAT_R11G11B10_FLOAT,
                                                   DXGI_FORMAT_R11G11B10_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R11G11B10_FLOAT,
                                                   ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GenerateMip<R11G11B10F>,
                                                   ReadColor<R11G11B10F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16B16A16_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GL_RGBA16F,
                                                   DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                   DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                   DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                   ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GenerateMip<R16G16B16A16F>,
                                                   ReadColor<R16G16B16A16F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16B16A16_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16B16A16_SINT,
                                                   GL_RGBA16I,
                                                   DXGI_FORMAT_R16G16B16A16_SINT,
                                                   DXGI_FORMAT_R16G16B16A16_SINT,
                                                   DXGI_FORMAT_R16G16B16A16_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16B16A16_SINT,
                                                   ANGLE_FORMAT_R16G16B16A16_SINT,
                                                   GenerateMip<R16G16B16A16S>,
                                                   ReadColor<R16G16B16A16S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16B16A16_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                   GL_RGBA16_SNORM_EXT,
                                                   DXGI_FORMAT_R16G16B16A16_SNORM,
                                                   DXGI_FORMAT_R16G16B16A16_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16B16A16_SNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                   GenerateMip<R16G16B16A16S>,
                                                   ReadColor<R16G16B16A16S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16B16A16_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16B16A16_UINT,
                                                   GL_RGBA16UI,
                                                   DXGI_FORMAT_R16G16B16A16_UINT,
                                                   DXGI_FORMAT_R16G16B16A16_UINT,
                                                   DXGI_FORMAT_R16G16B16A16_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16B16A16_UINT,
                                                   ANGLE_FORMAT_R16G16B16A16_UINT,
                                                   GenerateMip<R16G16B16A16>,
                                                   ReadColor<R16G16B16A16, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16B16A16_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   GL_NONE,
                                                   DXGI_FORMAT_R16G16B16A16_UNORM,
                                                   DXGI_FORMAT_R16G16B16A16_UNORM,
                                                   DXGI_FORMAT_R16G16B16A16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16B16A16_UNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   GenerateMip<R16G16B16A16>,
                                                   ReadColor<R16G16B16A16, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16_FLOAT,
                                                   GL_RG16F,
                                                   DXGI_FORMAT_R16G16_FLOAT,
                                                   DXGI_FORMAT_R16G16_FLOAT,
                                                   DXGI_FORMAT_R16G16_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16_FLOAT,
                                                   ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GenerateMip<R16G16F>,
                                                   ReadColor<R16G16F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16_SINT,
                                                   GL_RG16I,
                                                   DXGI_FORMAT_R16G16_SINT,
                                                   DXGI_FORMAT_R16G16_SINT,
                                                   DXGI_FORMAT_R16G16_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16_SINT,
                                                   ANGLE_FORMAT_R16G16B16A16_SINT,
                                                   GenerateMip<R16G16S>,
                                                   ReadColor<R16G16S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16_SNORM,
                                                   GL_RG16_SNORM_EXT,
                                                   DXGI_FORMAT_R16G16_SNORM,
                                                   DXGI_FORMAT_R16G16_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16_SNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                   GenerateMip<R16G16S>,
                                                   ReadColor<R16G16S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16_UINT,
                                                   GL_RG16UI,
                                                   DXGI_FORMAT_R16G16_UINT,
                                                   DXGI_FORMAT_R16G16_UINT,
                                                   DXGI_FORMAT_R16G16_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16_UINT,
                                                   ANGLE_FORMAT_R16G16B16A16_UINT,
                                                   GenerateMip<R16G16>,
                                                   ReadColor<R16G16, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16G16_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16G16_UNORM,
                                                   GL_NONE,
                                                   DXGI_FORMAT_R16G16_UNORM,
                                                   DXGI_FORMAT_R16G16_UNORM,
                                                   DXGI_FORMAT_R16G16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16G16_UNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   GenerateMip<R16G16>,
                                                   ReadColor<R16G16, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16_FLOAT,
                                                   GL_R16F,
                                                   DXGI_FORMAT_R16_FLOAT,
                                                   DXGI_FORMAT_R16_FLOAT,
                                                   DXGI_FORMAT_R16_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16_FLOAT,
                                                   ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GenerateMip<R16F>,
                                                   ReadColor<R16F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16_SINT,
                                                   GL_R16I,
                                                   DXGI_FORMAT_R16_SINT,
                                                   DXGI_FORMAT_R16_SINT,
                                                   DXGI_FORMAT_R16_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16_SINT,
                                                   ANGLE_FORMAT_R16G16B16A16_SINT,
                                                   GenerateMip<R16S>,
                                                   ReadColor<R16S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16_SNORM,
                                                   GL_R16_SNORM_EXT,
                                                   DXGI_FORMAT_R16_SNORM,
                                                   DXGI_FORMAT_R16_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16_SNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                   GenerateMip<R16S>,
                                                   ReadColor<R16S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16_UINT,
                                                   GL_R16UI,
                                                   DXGI_FORMAT_R16_UINT,
                                                   DXGI_FORMAT_R16_UINT,
                                                   DXGI_FORMAT_R16_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16_UINT,
                                                   ANGLE_FORMAT_R16G16B16A16_UINT,
                                                   GenerateMip<R16>,
                                                   ReadColor<R16, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R16_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R16_UNORM,
                                                   GL_NONE,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R16_UNORM,
                                                   ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                   GenerateMip<R16>,
                                                   ReadColor<R16, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32B32A32_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   GL_RGBA32F,
                                                   DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                   DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                   DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   GenerateMip<R32G32B32A32F>,
                                                   ReadColor<R32G32B32A32F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32B32A32_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32B32A32_SINT,
                                                   GL_RGBA32I,
                                                   DXGI_FORMAT_R32G32B32A32_SINT,
                                                   DXGI_FORMAT_R32G32B32A32_SINT,
                                                   DXGI_FORMAT_R32G32B32A32_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32B32A32_SINT,
                                                   ANGLE_FORMAT_R32G32B32A32_SINT,
                                                   GenerateMip<R32G32B32A32S>,
                                                   ReadColor<R32G32B32A32S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32B32A32_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32B32A32_UINT,
                                                   GL_RGBA32UI,
                                                   DXGI_FORMAT_R32G32B32A32_UINT,
                                                   DXGI_FORMAT_R32G32B32A32_UINT,
                                                   DXGI_FORMAT_R32G32B32A32_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32B32A32_UINT,
                                                   ANGLE_FORMAT_R32G32B32A32_UINT,
                                                   GenerateMip<R32G32B32A32>,
                                                   ReadColor<R32G32B32A32, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32_FLOAT,
                                                   GL_RG32F,
                                                   DXGI_FORMAT_R32G32_FLOAT,
                                                   DXGI_FORMAT_R32G32_FLOAT,
                                                   DXGI_FORMAT_R32G32_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32_FLOAT,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   GenerateMip<R32G32F>,
                                                   ReadColor<R32G32F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32_SINT,
                                                   GL_RG32I,
                                                   DXGI_FORMAT_R32G32_SINT,
                                                   DXGI_FORMAT_R32G32_SINT,
                                                   DXGI_FORMAT_R32G32_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32_SINT,
                                                   ANGLE_FORMAT_R32G32B32A32_SINT,
                                                   GenerateMip<R32G32S>,
                                                   ReadColor<R32G32S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32G32_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32G32_UINT,
                                                   GL_RG32UI,
                                                   DXGI_FORMAT_R32G32_UINT,
                                                   DXGI_FORMAT_R32G32_UINT,
                                                   DXGI_FORMAT_R32G32_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32G32_UINT,
                                                   ANGLE_FORMAT_R32G32B32A32_UINT,
                                                   GenerateMip<R32G32>,
                                                   ReadColor<R32G32, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32_FLOAT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32_FLOAT,
                                                   GL_R32F,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32_FLOAT,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   GenerateMip<R32F>,
                                                   ReadColor<R32F, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32_SINT,
                                                   GL_R32I,
                                                   DXGI_FORMAT_R32_SINT,
                                                   DXGI_FORMAT_R32_SINT,
                                                   DXGI_FORMAT_R32_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32_SINT,
                                                   ANGLE_FORMAT_R32G32B32A32_SINT,
                                                   GenerateMip<R32S>,
                                                   ReadColor<R32S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R32_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R32_UINT,
                                                   GL_R32UI,
                                                   DXGI_FORMAT_R32_UINT,
                                                   DXGI_FORMAT_R32_UINT,
                                                   DXGI_FORMAT_R32_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R32_UINT,
                                                   ANGLE_FORMAT_R32G32B32A32_UINT,
                                                   GenerateMip<R32>,
                                                   ReadColor<R32, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_SINT,
                                                   GL_RGBA8I,
                                                   DXGI_FORMAT_R8G8B8A8_SINT,
                                                   DXGI_FORMAT_R8G8B8A8_SINT,
                                                   DXGI_FORMAT_R8G8B8A8_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_SINT,
                                                   ANGLE_FORMAT_R8G8B8A8_SINT,
                                                   GenerateMip<R8G8B8A8S>,
                                                   ReadColor<R8G8B8A8S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GL_RGBA8_SNORM,
                                                   DXGI_FORMAT_R8G8B8A8_SNORM,
                                                   DXGI_FORMAT_R8G8B8A8_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_SNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GenerateMip<R8G8B8A8S>,
                                                   ReadColor<R8G8B8A8S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_UINT,
                                                   GL_RGBA8UI,
                                                   DXGI_FORMAT_R8G8B8A8_UINT,
                                                   DXGI_FORMAT_R8G8B8A8_UINT,
                                                   DXGI_FORMAT_R8G8B8A8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_UINT,
                                                   ANGLE_FORMAT_R8G8B8A8_UINT,
                                                   GenerateMip<R8G8B8A8>,
                                                   ReadColor<R8G8B8A8, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GL_RGBA8,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8G8B8A8>,
                                                   ReadColor<R8G8B8A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE,
                                                   GL_RGBA8,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8G8B8A8>,
                                                   ReadColor<R8G8B8A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   GL_SRGB8_ALPHA8,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   GenerateMip<R8G8B8A8>,
                                                   ReadColor<R8G8B8A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE,
                                                   GL_SRGB8_ALPHA8,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8G8B8A8>,
                                                   ReadColor<R8G8B8A8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_SINT,
                                                   GL_RG8I,
                                                   DXGI_FORMAT_R8G8_SINT,
                                                   DXGI_FORMAT_R8G8_SINT,
                                                   DXGI_FORMAT_R8G8_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_SINT,
                                                   ANGLE_FORMAT_R8G8B8A8_SINT,
                                                   GenerateMip<R8G8S>,
                                                   ReadColor<R8G8S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_SNORM,
                                                   GL_RG8_SNORM,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GenerateMip<R8G8S>,
                                                   ReadColor<R8G8S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_SNORM_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_SNORM_NONRENDERABLE,
                                                   GL_RG8_SNORM,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_SNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GenerateMip<R8G8S>,
                                                   ReadColor<R8G8S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_UINT,
                                                   GL_RG8UI,
                                                   DXGI_FORMAT_R8G8_UINT,
                                                   DXGI_FORMAT_R8G8_UINT,
                                                   DXGI_FORMAT_R8G8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_UINT,
                                                   ANGLE_FORMAT_R8G8B8A8_UINT,
                                                   GenerateMip<R8G8>,
                                                   ReadColor<R8G8, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_UNORM,
                                                   GL_RG8,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8G8>,
                                                   ReadColor<R8G8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8G8_UNORM_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8G8_UNORM_NONRENDERABLE,
                                                   GL_RG8,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8G8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8G8>,
                                                   ReadColor<R8G8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_SINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_SINT,
                                                   GL_R8I,
                                                   DXGI_FORMAT_R8_SINT,
                                                   DXGI_FORMAT_R8_SINT,
                                                   DXGI_FORMAT_R8_SINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_SINT,
                                                   ANGLE_FORMAT_R8G8B8A8_SINT,
                                                   GenerateMip<R8S>,
                                                   ReadColor<R8S, GLint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_SNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_SNORM,
                                                   GL_R8_SNORM,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GenerateMip<R8S>,
                                                   ReadColor<R8S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_SNORM_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_SNORM_NONRENDERABLE,
                                                   GL_R8_SNORM,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_SNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                   GenerateMip<R8S>,
                                                   ReadColor<R8S, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_UINT,
                                                   GL_R8UI,
                                                   DXGI_FORMAT_R8_UINT,
                                                   DXGI_FORMAT_R8_UINT,
                                                   DXGI_FORMAT_R8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_UINT,
                                                   ANGLE_FORMAT_R8G8B8A8_UINT,
                                                   GenerateMip<R8>,
                                                   ReadColor<R8, GLuint>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_UNORM:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_UNORM,
                                                   GL_R8,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8>,
                                                   ReadColor<R8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R8_UNORM_NONRENDERABLE:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R8_UNORM_NONRENDERABLE,
                                                   GL_R8,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R8_UNORM,
                                                   ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                   GenerateMip<R8>,
                                                   ReadColor<R8, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_R9G9B9E5_SHAREDEXP:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_R9G9B9E5_SHAREDEXP,
                                                   GL_RGB9_E5,
                                                   DXGI_FORMAT_R9G9B9E5_SHAREDEXP,
                                                   DXGI_FORMAT_R9G9B9E5_SHAREDEXP,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_R9G9B9E5_SHAREDEXP,
                                                   ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                   GenerateMip<R9G9B9E5>,
                                                   ReadColor<R9G9B9E5, GLfloat>);
            return formatInfo;
        }
        case ANGLE_FORMAT_X24_TYPELESS_G8_UINT:
        {
            static const ANGLEFormatSet formatInfo(ANGLE_FORMAT_X24_TYPELESS_G8_UINT,
                                                   GL_DEPTH24_STENCIL8_OES,
                                                   DXGI_FORMAT_R24G8_TYPELESS,
                                                   DXGI_FORMAT_X24_TYPELESS_G8_UINT,
                                                   DXGI_FORMAT_UNKNOWN,
                                                   DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                   DXGI_FORMAT_X24_TYPELESS_G8_UINT,
                                                   ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                   nullptr,
                                                   nullptr);
            return formatInfo;
        }

        default:
            break;
    }
    // clang-format on

    UNREACHABLE();
    static const ANGLEFormatSet defaultInfo;
    return defaultInfo;
}

const TextureFormat &GetTextureFormatInfo(GLenum internalFormat,
                                          const Renderer11DeviceCaps &renderer11DeviceCaps)
{
    // clang-format off
    switch (internalFormat)
    {
        case GL_ALPHA:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ALPHA16F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_ALPHA32F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_ALPHA8_EXT:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_BGR5_A1_ANGLEX:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_BGRA4_ANGLEX:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_BGRA8_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_BGRA_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_B8G8R8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_COMPRESSED_R11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8_UNORM_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RG11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8_UNORM_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGB8_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE,
                                                         Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE,
                                                         Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA8_ETC2_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_BC1_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_BC2_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_BC3_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_BC1_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_COMPRESSED_SIGNED_R11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8_SNORM_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SIGNED_RG11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8_SNORM_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE,
                                                         Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH24_STENCIL8:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL10,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL9_3,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH32F_STENCIL8:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D32_FLOAT_S8X24_UINT_FL10,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_NONE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT16:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D16_UNORM_FL10,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D16_UNORM_FL9_3,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT24:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL10,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL9_3,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT32F:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D32_FLOAT,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_NONE,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT32_OES:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL10,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ETC1_RGB8_LOSSY_DECODE_ANGLE:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_BC1_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_ETC1_RGB8_OES:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM_NONRENDERABLE,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_LUMINANCE:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_LUMINANCE16F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                     Initialize4ComponentData<GLhalf, 0x0000, 0x0000, 0x0000, gl::Float16One>);
            return textureFormat;
        }
        case GL_LUMINANCE32F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000, gl::Float32One>);
            return textureFormat;
        }
        case GL_LUMINANCE8_ALPHA8_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_LUMINANCE8_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_LUMINANCE_ALPHA:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_LUMINANCE_ALPHA16F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_LUMINANCE_ALPHA32F_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_NONE:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_NONE,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R11F_G11F_B10F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R11G11B10_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R16F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R16I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R16UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R16_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R16_SNORM_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R32F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R32I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R32UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R8I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R8UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_R8_SNORM:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG16F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG16I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG16UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG16_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG16_SNORM_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG32F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG32I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG32UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG8I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG8UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RG8_SNORM:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGB:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_RGB10_A2:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R10G10B10A2_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGB10_A2UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R10G10B10A2_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGB16F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                     Initialize4ComponentData<GLhalf, 0x0000, 0x0000, 0x0000, gl::Float16One>);
            return textureFormat;
        }
        case GL_RGB16I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_SINT,
                                                     Initialize4ComponentData<GLshort, 0x0000, 0x0000, 0x0000, 0x0001>);
            return textureFormat;
        }
        case GL_RGB16UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_UINT,
                                                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x0001>);
            return textureFormat;
        }
        case GL_RGB16_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                     Initialize4ComponentData<GLubyte, 0x0000, 0x0000, 0x0000, 0xFFFF>);
            return textureFormat;
        }
        case GL_RGB16_SNORM_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x7FFF>);
            return textureFormat;
        }
        case GL_RGB32F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000, gl::Float32One>);
            return textureFormat;
        }
        case GL_RGB32I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_SINT,
                                                     Initialize4ComponentData<GLint, 0x00000000, 0x00000000, 0x00000000, 0x00000001>);
            return textureFormat;
        }
        case GL_RGB32UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_UINT,
                                                     Initialize4ComponentData<GLuint, 0x00000000, 0x00000000, 0x00000000, 0x00000001>);
            return textureFormat;
        }
        case GL_RGB565:
        {
            if (SupportsFormat<DXGI_FORMAT_B5G6R5_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                         Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B5G6R5_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_B5G6R5_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB5_A1:
        {
            if (SupportsFormat<DXGI_FORMAT_B5G5R5A1_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B5G5R5A1_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_B5G5R5A1_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_RGB8I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_SINT,
                                                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x01>);
            return textureFormat;
        }
        case GL_RGB8UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UINT,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0x01>);
            return textureFormat;
        }
        case GL_RGB8_SNORM:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x7F>);
            return textureFormat;
        }
        case GL_RGB9_E5:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R9G9B9E5_SHAREDEXP,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA16F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA16I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA16UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA16_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA16_SNORM_EXT:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R16G16B16A16_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA32F:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_FLOAT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA32I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA32UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R32G32B32A32_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA4:
        {
            if (SupportsFormat<DXGI_FORMAT_B4G4R4A4_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B4G4R4A4_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_B4G4R4A4_UNORM,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA8I:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_SINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA8UI:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UINT,
                                                     nullptr);
            return textureFormat;
        }
        case GL_RGBA8_SNORM:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_SNORM,
                                                     nullptr);
            return textureFormat;
        }
        case GL_SRGB8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB_NONRENDERABLE,
                                                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>);
            return textureFormat;
        }
        case GL_SRGB8_ALPHA8:
        {
            static const TextureFormat textureFormat(internalFormat,
                                                     ANGLE_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                     nullptr);
            return textureFormat;
        }
        case GL_STENCIL_INDEX8:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_X24_TYPELESS_G8_UINT,
                                                         nullptr);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat(internalFormat,
                                                         ANGLE_FORMAT_D24_UNORM_S8_UINT_FL9_3,
                                                         nullptr);
                return textureFormat;
            }
            else
            {
                break;
            }
        }

        default:
            break;
    }
    // clang-format on

    static const TextureFormat defaultInfo(GL_NONE, ANGLE_FORMAT_NONE, nullptr);
    return defaultInfo;
}  // GetTextureFormatInfo

}  // namespace d3d11

}  // namespace rx
