/*
 * Copyright (c) 1997, 1998
 *      Jens Arvid Nilsson, jnilsson@ludd.luth.se. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*$Id: util.h,v 1.11 1998/05/24 14:14:16 jens Exp $*/  
#ifndef UTIL_H
#define UTIL_H

#include <sys/socket.h>
#include <net/if.h>
#include <net/if_ether.h>
#include <netinet/in.h>

#define min(a,b)        ((a) < (b) ? (a) : (b))
#define max(a,b)        ((a) > (b) ? (a) : (b))

#define A_TO_ARP(p)		(struct arphdr *) ((struct ether_header *) (p) + 1)
#define A_FROM_ETH(p)	ar_sha(A_TO_ARP(p))
#define A_TO_ETH(p)		ar_tha(A_TO_ARP(p))
#define A_FROM_IP(p)	ar_spa(A_TO_ARP(p))
#define A_TO_IP(p)		ar_tpa(A_TO_ARP(p))

#define MAXLINE		4096


#if 0
struct if_rules {
	struct if_rules *q_forw;
	struct if_rules *q_back;
	char	szDevice[IFNAMSIZ];
	struct in_addr 	arpnet, arpmask; 
	struct ether_addr ifhwa;
	struct ip_list *pHIp_list;
	struct net_list *pHNo_net;
};

struct ip_list {
	struct ip_list *q_forw;
	struct ip_list *q_back;
	struct in_addr ip;
};

struct net_list {
	struct net_list *q_forw;
	struct net_list *q_back;
	struct in_addr net, mask;
};
#endif

LIST_HEAD(net_list, net_elm);
struct net_elm {
	struct in_addr net, mask;
	LIST_ENTRY(net_elm) entries;
};

LIST_HEAD(ip_list, ip_elm);
struct ip_elm {
	struct in_addr ip;
	LIST_ENTRY(ip_elm) entries;
};


LIST_HEAD(if_list, if_elm);
struct if_elm {
	char    szDevice[IFNAMSIZ];
	int		fdDevice;
	int		have_arpnet;
	int		broadcast;
	struct in_addr  arpnet, arpmask;
	struct ether_addr ifhwa;
	struct ip_list sNo_answer;
	struct ip_list sProxy;
	struct net_list sNo_net;
	LIST_ENTRY(if_elm) entries;
};

extern struct if_list sIf_list;

void    insque(void *elem, void *pred);
void    remque(void *elem);

int     ip_in_list(char *msg, struct ip_list * pIp_list);
void    IfIoctl(int fd, unsigned long request, char *argp);
int		ip_pass_rules(struct in_addr *from_ip, struct in_addr *for_ip, struct if_elm *pIf_elm);
void   *Malloc(size_t size);
void 	Read_conf(FILE * pConfigFile);
void	Inet_aton(const char *cp, struct in_addr *addr);
void	Ether_aton(const char *s, struct ether_addr *e);
void	daemon_init(const char *pname, int facility);
void	Get_if_info(char *szDevice, struct ether_addr *ifhwa, struct in_addr *ifip);

#endif
