/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class SequenceDiagramArea {
    private final double sequenceWidth;
    private final double sequenceHeight;
    private double headerWidth;
    private double headerHeight;
    private double headerMargin;
    private double titleWidth;
    private double titleHeight;
    private double footerWidth;
    private double footerHeight;
    private double footerMargin;

    public SequenceDiagramArea(double width, double height) {
        this.sequenceWidth = width;
        this.sequenceHeight = height;
    }

    public void setTitleArea(double titleWidth, double titleHeight) {
        this.titleWidth = titleWidth;
        this.titleHeight = titleHeight;
    }

    public void setHeaderArea(double headerWidth, double headerHeight, double headerMargin) {
        this.headerWidth = headerWidth;
        this.headerHeight = headerHeight;
        this.headerMargin = headerMargin;
    }

    public void setFooterArea(double footerWidth, double footerHeight, double footerMargin) {
        this.footerWidth = footerWidth;
        this.footerHeight = footerHeight;
        this.footerMargin = footerMargin;
    }

    public double getWidth() {
        double result = this.sequenceWidth;
        if (this.headerWidth > result) {
            result = this.headerWidth;
        }
        if (this.titleWidth > result) {
            result = this.titleWidth;
        }
        if (this.footerWidth > result) {
            result = this.footerWidth;
        }
        return result;
    }

    public double getHeight() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.footerHeight;
    }

    public double getTitleX() {
        return (this.getWidth() - this.titleWidth) / 2.0;
    }

    public double getTitleY() {
        return this.headerHeight + this.headerMargin;
    }

    public double getSequenceAreaX() {
        return (this.getWidth() - this.sequenceWidth) / 2.0;
    }

    public double getSequenceAreaY() {
        return this.getTitleY() + this.titleHeight;
    }

    public double getHeaderY() {
        return 0.0;
    }

    public double getFooterY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin;
    }

    public double getFooterX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.footerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.footerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public double getHeaderX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.headerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.headerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }
}

