/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageActivity
extends AbstractEntityImage {
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Url url;
    private final Bibliotekon bibliotekon;

    public EntityImageActivity(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.ACTIVITY, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.ACTIVITY, stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.getShapeType() == ShapeType.ROUND_RECTANGLE) {
            ug = this.drawNormal(ug);
        } else if (this.getShapeType() == ShapeType.OCTAGON) {
            ug = this.drawOctagon(ug);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.url != null) {
            ug.closeAction();
        }
    }

    private UGraphic drawOctagon(UGraphic ug) {
        Shape shape = this.bibliotekon.getShape(this.getEntity());
        Shadowable octagon = shape.getOctagon();
        if (this.getSkinParam().shadowing()) {
            octagon.setDeltaShadow(4.0);
        }
        ug = this.applyColors(ug);
        ug.apply(new UStroke(1.5)).draw(octagon);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    private UGraphic drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            rect.setDeltaShadow(4.0);
        }
        ug = this.applyColors(ug);
        ug.apply(new UStroke(1.5)).draw(rect);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    private UGraphic applyColors(UGraphic ug) {
        ug = ug.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBorder, this.getStereo())));
        HtmlColor backcolor = this.getEntity().getSpecificBackColor();
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBackground, this.getStereo());
        }
        ug = ug.apply(new UChangeBackColor(backcolor));
        return ug;
    }

    @Override
    public ShapeType getShapeType() {
        Stereotype stereotype = this.getStereo();
        if (this.getSkinParam().useOctagonForActivity(stereotype)) {
            return ShapeType.OCTAGON;
        }
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

