/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionIf
implements Instruction,
InstructionCollection {
    private final List<Branch> thens = new ArrayList<Branch>();
    private Branch elseBranch;
    private final ISkinParam skinParam;
    private final Instruction parent;
    private Branch current;
    private final LinkRendering inlinkRendering;
    private final Swimlane swimlane;
    private Display note;
    private NotePosition position;

    public InstructionIf(Swimlane swimlane, Instruction parent, Display labelTest, Display whenThen, LinkRendering inlinkRendering, HtmlColor color, ISkinParam skinParam) {
        this.parent = parent;
        this.skinParam = skinParam;
        this.inlinkRendering = inlinkRendering;
        this.swimlane = swimlane;
        this.thens.add(new Branch(swimlane, whenThen, labelTest, color));
        this.current = this.thens.get(0);
    }

    @Override
    public void add(Instruction ins) {
        this.current.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        for (Branch branch : this.thens) {
            branch.updateFtile(factory);
        }
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null);
        }
        this.elseBranch.updateFtile(factory);
        Ftile result = factory.createIf(this.swimlane, this.thens, this.elseBranch);
        if (this.note != null) {
            result = new FtileWithNoteOpale(result, this.note, this.position, this.skinParam, false);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public boolean swithToElse2(Display whenElse, LinkRendering nextLinkRenderer) {
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setInlinkRendering(nextLinkRenderer);
        this.current = this.elseBranch = new Branch(this.swimlane, whenElse, Display.NULL, null);
        return true;
    }

    public void elseIf(Display test, Display whenThen, LinkRendering nextLinkRenderer, HtmlColor color) {
        if (this.elseBranch != null) {
            throw new IllegalStateException();
        }
        this.current.setInlinkRendering(nextLinkRenderer);
        this.current = new Branch(this.swimlane, whenThen, test, color);
        this.thens.add(this.current);
    }

    public void endif(LinkRendering nextLinkRenderer) {
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null);
        }
        this.current.setInlinkRendering(nextLinkRenderer);
    }

    @Override
    public final boolean kill() {
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        if (this.current.isEmpty()) {
            this.note = note;
            this.position = position;
            return true;
        }
        return this.current.addNote(note, position);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.swimlane != null) {
            result.add(this.swimlane);
        }
        for (Branch branch : this.thens) {
            result.addAll(branch.getSwimlanes());
        }
        result.addAll(this.elseBranch.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Instruction getLast() {
        if (this.elseBranch == null) {
            return this.thens.get(this.thens.size() - 1).getLast();
        }
        return this.elseBranch.getLast();
    }
}

