# IANA Considerations

WAMP uses the Subprotocol Identifier `wamp` registered with the [WebSocket Subprotocol Name Registry](https://www.iana.org/assignments/websocket/websocket.xhtml), operated by the Internet Assigned Numbers Authority (IANA).


# Conformance Requirements

All diagrams, examples, and notes in this specification are non-normative, as are all sections explicitly marked non-normative. Everything else in this specification is normative.

The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL NOT",
"SHOULD", "SHOULD NOT", "RECOMMENDED", "MAY", and "OPTIONAL" in
this document are to be interpreted as described in RFC 2119 [@?RFC2119].

Requirements phrased in the imperative as part of algorithms (such as "strip any leading space characters" or "return false and abort these steps") are to be interpreted with the meaning of the key word ("MUST", "SHOULD", "MAY", etc.) used in introducing the algorithm.

Conformance requirements phrased as algorithms or specific steps MAY  be implemented in any manner, so long as the end result is equivalent.

## Terminology and Other Conventions

Key terms such as named algorithms or definitions are indicated like _this_ when they first occur, and are capitalized throughout the text.

# Contributors

WAMP was developed in an open process from the beginning, and a lot of people have contributed ideas and other feedback. Here we are listing people who have opted in to being mentioned:

* Alexander Goedde
* Amber Brown
* Andrew Gillis
* David Chappelle
* Elvis Stansvik
* Emile Cormier
* Felipe Gasper
* Johan 't Hart
* Josh Soref
* Konstantin Burkalev
* Pahaz Blinov
* Paolo Angioletti
* Roberto Requena
* Roger Erens
* Christoph Herzog
* Tobias Oberstein
* Zhigang Wang
