#ifndef _FSCOMPAT_H
#define _FSCOMPAT_H

/* set up types for seeks and file sizes */
#include <sys/types.h>

#ifndef OFF_T
# ifdef __convex__
#  define OFF_T off64_t
# else
#  define OFF_T off_t
# endif
#endif /* OFF_T */

#ifndef LSEEK
# ifdef __convex__
#  define LSEEK lseek64
# else
#  define LSEEK lseek
# endif
#endif /*LSEEK */


#ifndef STAT
# ifdef __convex__
#  define STAT stat64
# else
#  define STAT stat
# endif
#endif /*STAT */

#ifndef FSTAT
# ifdef __convex__
#  define FSTAT fstat64
# else
#  define FSTAT fstat
# endif
#endif

#ifndef STAT_T
# ifdef __convex__
#  define STAT_T stat64_t
# else
#  define STAT_T struct stat
# endif
#endif /*STAT_T */


#ifndef INO_T
# ifdef __convex__
#  define INO_T ino64_t
# else
#  define INO_T ino_t
# endif
#endif /*LSEEK */



/* type of a disk inode structure */

#if defined __convex__
# include <ufs/inode.h>
# include <ufs/fs.h>
# include <sys/dmonfh.h>
#endif

#if defined __NetBSD__
# include <ufs/ufs/dinode.h>
# include <ufs/ffs/fs.h>
#endif

#if defined sgi
# include <sys/fs/efs_ino.h>
# include <sys/fs/efs_fs.h>
# include <sys/fs/efs_sb.h>
# define SBLOCK EFS_SUPERBB
# define SBLOCK_T struct efs
# ifndef EFS_NEWMAGIC
#  define MAGIC EFS_MAGIC
# else
#  define MAGIC EFS_NEWMAGIC
# endif
#endif


#ifdef sgi
# define DINODE_T struct efs_dinode
#else
# define DINODE_T struct dinode
#endif

/* superblock access */

#ifdef __convex__
# define SB_OPENFLAGS (O_RDONLY | O_LARGEFILE | O_NONBLOCK)
#else 
# define SB_OPENFLAGS (O_RDONLY | O_NONBLOCK)
#endif

#ifndef sgi 
# define SBLOCK_T struct fs
# define MAGIC FS_MAGIC
#endif

/* commonly used multipliers */

#ifndef KB
#define KB 1024
#endif
#ifndef MB
#define MB (1024 * 1024)
#endif
#ifndef GB
#define GB (MB * 1024)
#endif

#endif /* end _FSCOMPAT_H */

